/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp.agentIpTransport;

import java.io.IOException;
import java.net.Socket;
import org.comproxy.tcp.agentIpTransport.AgentIpTrafficReader;
import org.comproxy.tcp.agentIpTransport.AgentIpTrafficWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentIpTransport
implements Runnable {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private Socket socket;
    private volatile boolean active;
    private AgentIpTrafficReader agentIpTrafficReader;
    private AgentIpTrafficWriter agentIpTrafficWriter;

    public AgentIpTransport(Socket socket) throws IOException {
        this.socket = socket;
        this.agentIpTrafficReader = new AgentIpTrafficReader(socket);
        this.agentIpTrafficWriter = new AgentIpTrafficWriter(socket);
        this.active = true;
    }

    @Override
    public void run() {
        try {
            this.active = true;
            this.agentIpTrafficReader.start();
            this.agentIpTrafficWriter.start();
            while (!Thread.interrupted()) {
                if (!this.agentIpTrafficReader.isInterrupted() && !this.agentIpTrafficReader.isActive()) {
                    this.active = false;
                    this.agentIpTrafficReader.interrupt();
                    this.agentIpTrafficWriter.interrupt();
                }
                if (!this.agentIpTrafficWriter.isInterrupted() && !this.agentIpTrafficWriter.isActive()) {
                    this.active = false;
                    this.agentIpTrafficWriter.interrupt();
                    this.agentIpTrafficReader.interrupt();
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.LOG.error("Error", e);
        }
        finally {
            try {
                this.agentIpTrafficReader.interrupt();
                this.agentIpTrafficWriter.interrupt();
                this.socket.close();
            }
            catch (Exception e) {
                this.LOG.error("Error", e);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }
}

