/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp.agentIpTransport;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.comproxy.CommonResources;
import org.comproxy.ProxyModel;
import org.comproxy.reader.ComPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentIpTrafficWriter
extends Thread {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private Socket socket;
    private DataOutputStream bos;
    private volatile boolean active = true;

    public AgentIpTrafficWriter(Socket s) throws IOException {
        this.socket = s;
        this.bos = new DataOutputStream(s.getOutputStream());
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                for (Map.Entry<Integer, ProxyModel> entry : CommonResources.getInstance().entrySet()) {
                    ComPacket packet = this.getCommandForSend(entry.getValue());
                    if (packet == null) continue;
                    this.send(this.bos, packet);
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.LOG.error("Error", e);
        }
        finally {
            try {
                this.closeStream();
                this.socket.close();
            }
            catch (Exception e) {
                this.LOG.error("Error", e);
            }
        }
    }

    private void send(OutputStream out, ComPacket packet) throws IOException {
        try {
            out.write(packet.getPacketBody());
            out.flush();
            this.LOG.debug("send <-- <{}> {}", (Object)packet.getRecipientNumber(), (Object)packet);
        }
        catch (IOException eio) {
            this.LOG.error("SocketReader error", eio);
            Thread.currentThread().interrupt();
            this.closeStream();
            this.active = false;
        }
    }

    private ComPacket getCommandForSend(ProxyModel model) throws Exception {
        ComPacket packet = null;
        packet = model.getPacketToAgent();
        if (packet != null) {
            packet.setRecipientNumber(model.getInstanceNumber());
            return packet;
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    private void closeStream() {
        if (this.bos != null) {
            try {
                this.bos.close();
                this.bos = null;
            }
            catch (IOException e) {
                this.LOG.error("Error input stream error", e);
            }
        }
    }
}

