/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp.agentIpTransport;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import org.comproxy.CommonResources;
import org.comproxy.ProxyModel;
import org.comproxy.tcp.agentIpTransport.AgentIpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentIpTrafficServer
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AgentIpTrafficServer.class);
    private final int serverPort;
    private Thread socketReader;
    private Socket socket;
    private ServerSocket cashTrafficServer;
    protected AgentIpTransport agentIpTransport;

    public AgentIpTrafficServer(int agentDataPort) {
        this.serverPort = agentDataPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (this.socketReader != null) {
            this.socketReader.interrupt();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                log.error("Error close socket: {}", (Object)e.getMessage());
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    log.error("Error close socket finally: {}", (Object)e.getMessage());
                }
            }
        }
        if (this.cashTrafficServer != null) {
            try {
                this.cashTrafficServer.close();
            }
            catch (IOException e) {
                log.error("Error close serverSocket: {}", (Object)e.getMessage());
            }
            finally {
                try {
                    this.cashTrafficServer.close();
                }
                catch (IOException e) {
                    log.error("Error close serverSocket finally: {}", (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    public void run() {
        String address = "127.0.0.1";
        try {
            while (!Thread.interrupted()) {
                this.cashTrafficServer = new ServerSocket(this.serverPort);
                log.debug("Wait IP Client connection to {}:{}", (Object)address, (Object)this.serverPort);
                this.socket = this.cashTrafficServer.accept();
                log.debug("IP Client connected");
                if (this.socketReader == null) {
                    this.agentIpTransport = new AgentIpTransport(this.socket);
                    this.socketReader = new Thread(this.agentIpTransport);
                    this.socketReader.start();
                }
                boolean agentChannelIsWorking = true;
                while (agentChannelIsWorking) {
                    for (Map.Entry<Integer, ProxyModel> entry : CommonResources.getInstance().entrySet()) {
                        ProxyModel model = entry.getValue();
                        if (model.getHardwareChecker().isFiscalPrinterConnected() && this.agentIpTransport != null && this.agentIpTransport.isActive()) {
                            Thread.sleep(50L);
                            agentChannelIsWorking = true;
                            if (!model.isStopAgentTechProcess()) continue;
                            log.debug("Device connected {}", (Object)model.getInstanceNumber());
                            while (model.getQueueToAgentSize() > 0) {
                                Thread.sleep(50L);
                            }
                            model.setStopAgentTechProcess(false);
                            continue;
                        }
                        if (!model.getHardwareChecker().isFiscalPrinterConnected() && this.agentIpTransport != null && this.agentIpTransport.isActive()) {
                            if (model.isStopAgentTechProcess()) continue;
                            log.debug("Device disconnected {}", (Object)model.getInstanceNumber());
                            while (model.getQueueToAgentSize() > 0) {
                                Thread.sleep(50L);
                            }
                            model.setStopAgentTechProcess(true);
                            continue;
                        }
                        if (this.agentIpTransport == null || this.agentIpTransport.isActive()) continue;
                        agentChannelIsWorking = false;
                        model.setStopAgentTechProcess(true);
                    }
                }
                this.socketReader.interrupt();
                this.socket.close();
                this.cashTrafficServer.close();
                this.socketReader = null;
                Thread.sleep(50L);
                log.debug("Client disconnected");
            }
        }
        catch (IOException e) {
            if (this.socket.isClosed()) {
                log.debug("Error start server {}:{}", address, this.serverPort, e);
            } else {
                log.error("Error start server {}:{}", address, this.serverPort, e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

