/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.comproxy.ProxyModel;
import org.comproxy.SettingValue;
import org.comproxy.WritableSetting;
import org.comproxy.com.ByteArrayLog;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.TcpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPService {
    private static final Logger LOG = LoggerFactory.getLogger(TCPService.class);
    private static final int HEADER_SIZE = 30;
    private ProxyModel model;

    public TCPService(ProxyModel model) {
        this.model = model;
    }

    public ComPacket sendToOism(ComPacket packet) {
        return this.sendCommandToTCP(packet, this.model.getSettings().getOismIP(), this.model.getSettings().getOismTimeout(), 3);
    }

    public ComPacket sendToOkp(ComPacket packet) {
        return this.sendCommandToTCP(packet, this.model.getSettings().getOkpIP(), this.model.getSettings().getOkpTimeout(), 30);
    }

    private int getTimeout(SettingValue timeout, int defaultTimeout) {
        String value;
        if (!timeout.isValid()) {
            this.model.getSettings().refreshIfExpired(timeout);
        }
        if ((value = timeout.getValue()) == null || value.isEmpty()) {
            return defaultTimeout;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultTimeout;
        }
    }

    public ComPacket sendCommandToTCP(ComPacket packet, WritableSetting ip, SettingValue timeout, int defaultTimeout) {
        try {
            int effectiveTimeout = (int)TimeUnit.SECONDS.toMillis(this.getTimeout(timeout, defaultTimeout));
            TcpHeader tcpHeader = packet.getTcpHeader();
            if (tcpHeader.getDstIp().equals("0.0.0.0")) {
                this.model.getSettings().refresh(ip);
                return ComPacket.NAK_PACKET;
            }
            byte[] tcpBody = new byte[packet.getPacketBody().length - 40];
            System.arraycopy(packet.getPacketBody(), 40, tcpBody, 0, tcpBody.length);
            ByteArrayOutputStream tcpBodyOut = new ByteArrayOutputStream();
            tcpBodyOut.write(tcpBody);
            return this.sendPacket(tcpHeader, tcpBodyOut, effectiveTimeout, ip);
        }
        catch (Exception e) {
            return ComPacket.NAK_PACKET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComPacket sendPacket(TcpHeader tcpHeader, ByteArrayOutputStream tcpBodyOut, int timeout, WritableSetting ip) {
        String host = tcpHeader.getDstIp();
        int port = tcpHeader.getDstPort();
        Socket requestSocket = new Socket();
        try {
            requestSocket.setSoTimeout(timeout);
            InetSocketAddress socketAddress = new InetSocketAddress(host, port);
            requestSocket.setSoTimeout(timeout);
            requestSocket.connect(socketAddress, timeout);
            this.send(new BufferedOutputStream(requestSocket.getOutputStream()), tcpBodyOut);
            ComPacket comPacket = this.readMark(new BufferedInputStream(requestSocket.getInputStream()), tcpHeader, timeout);
            return comPacket;
        }
        catch (Exception ex) {
            if (ex instanceof SocketTimeoutException && ex.getMessage() != null) {
                LOG.error("Unable to connect to {}:{} ({})", host, port, ex.getMessage());
            } else {
                LOG.error("Unable to connect to {}:{}", (Object)host, (Object)port);
            }
            this.model.getSettings().refreshIfExpired(ip);
            ComPacket comPacket = ComPacket.NAK_PACKET;
            return comPacket;
        }
        finally {
            this.closeSocket(requestSocket);
        }
    }

    private void closeSocket(Socket requestSocket) {
        try {
            requestSocket.close();
        }
        catch (IOException ex) {
            LOG.error("Error on close {}", (Object)ex.getMessage());
        }
    }

    private void send(OutputStream out, ByteArrayOutputStream tcpBodyOut) throws IOException {
        byte[] bytes = tcpBodyOut.toByteArray();
        LOG.debug("Sending data ({}): {}", (Object)bytes.length, (Object)ByteArrayLog.onlyHex(bytes));
        out.write(bytes);
        out.flush();
    }

    protected ComPacket readMark(InputStream in, TcpHeader tcpHeader, int timeout) throws IOException {
        byte[] head = this.readSocketStream(in, 30, timeout, "head");
        int messageLength = TCPService.getPacketLength(head);
        LOG.debug("Read header (message length {}): {}", (Object)messageLength, (Object)ByteArrayLog.onlyHex(head));
        byte[] data = this.readSocketStream(in, messageLength, timeout, "body");
        LOG.debug("Read data ({}): {}", (Object)data.length, (Object)ByteArrayLog.onlyHex(data));
        ByteArrayOutputStream fullOut = new ByteArrayOutputStream(head.length + data.length);
        fullOut.write(head);
        fullOut.write(data);
        return this.getResponse(fullOut, tcpHeader);
    }

    private ComPacket getResponse(ByteArrayOutputStream response, TcpHeader tcpHeader) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TcpHeader responseTcpHeader = new TcpHeader(tcpHeader.asResponse(response.size() + 40));
        baos.write(responseTcpHeader.getBody());
        baos.write(response.toByteArray());
        return new ComPacket(baos.toByteArray(), ComPacket.STATUS.TCP, null, null);
    }

    private byte[] readSocketStream(InputStream is, int partSize, long timeout, String description) throws IOException {
        byte[] head = new byte[partSize];
        int allCount = 0;
        long timeOutStart = System.currentTimeMillis();
        while (is.available() >= 0) {
            int read = is.read(head, allCount, partSize - allCount);
            allCount += read;
            if (read == -1) {
                throw new IOException("read TCP " + description + " fail");
            }
            if (read == 0) {
                if (timeOutStart + timeout > System.currentTimeMillis()) {
                    throw new IOException("Timeout get answer " + description + " from Server");
                }
            } else {
                timeOutStart = System.currentTimeMillis();
            }
            if (allCount < partSize) continue;
        }
        if (allCount == partSize) {
            return head;
        }
        throw new IOException("Can't get answer " + description + " from Server, get " + allCount + " bytes");
    }

    private static int getPacketLength(byte[] buffer) {
        return buffer[24] & 0xFF | (buffer[25] & 0xFF) << 8;
    }
}

