/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.config.portFinder;

import jssc.SerialPort;
import org.comproxy.ProxyModel;
import org.comproxy.config.ProxyConfig;
import org.comproxy.config.SerialWriterThread;
import org.comproxy.config.portFinder.PortData;
import org.comproxy.config.portFinder.PortFinderModel;
import org.comproxy.config.portFinder.PortResult;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.PackageReader;
import org.comproxy.reader.PackageReaderListener;
import org.comproxy.utils.ComUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class PortFinderThread
extends Thread
implements PackageReaderListener {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    protected ProxyConfig proxyConfig;
    private PackageReader packageReader;
    protected boolean twoFrMode;
    private String kktSerialNumber;
    protected String instanceId;

    public PortFinderThread(ProxyConfig proxyConfig, String instanceId) {
        this.proxyConfig = proxyConfig;
        this.twoFrMode = ComUtils.checkConfigForTwoPrinters(proxyConfig);
        this.packageReader = new PackageReader(false, this);
        this.instanceId = instanceId;
    }

    @Override
    public void run() {
        MDC.put("MARK", this.instanceId);
        while (!Thread.interrupted()) {
            PortData portData = PortFinderModel.getInstance().pollTask();
            if (portData != null) {
                PortResult portResult = this.checkSerialNumberHardware(portData);
                if (portResult != null) {
                    PortFinderModel.getInstance().addResult(portResult);
                }
                Thread.currentThread().interrupt();
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void command(ComPacket result) {
        if (result.getPacketCommand().equals("02")) {
            this.kktSerialNumber = result.getSerialNumberValue();
        }
    }

    protected abstract PortResult checkSerialNumberHardware(PortData var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PortResult checkPortBySerialNumberHardware(PortData portData, String portName) {
        SerialPort serialPort;
        block18: {
            block17: {
                serialPort = null;
                this.LOG.info("{} Check for {}", (Object)this.instanceId, (Object)portName);
                serialPort = new SerialPort(portName);
                serialPort.openPort();
                serialPort.setParams(57600, 8, 1, 0);
                this.LOG.info("{} Open {}", (Object)this.instanceId, (Object)portName);
                SerialWriterThread serialWriterThread = new SerialWriterThread(serialPort, this.makeGetSerialNumberComPacket().getPacketBody());
                serialWriterThread.start();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!serialWriterThread.isAlive()) break block17;
                serialWriterThread.interrupt();
                this.LOG.error("{} Timeout error in find port for serial number {} port: {}", this.instanceId, portData.getSerialNumber(), portName);
                PortResult portResult = null;
                if (serialPort == null || !serialPort.isOpened()) return portResult;
                try {
                    serialPort.closePort();
                    return portResult;
                }
                catch (Exception e) {
                    this.LOG.error("{} Error close port for {} {}", this.instanceId, portData.getSerialNumber(), portName, e);
                }
                return portResult;
            }
            byte[] data = serialPort.readBytes();
            serialPort.closePort();
            this.LOG.info("{} Close {}", (Object)this.instanceId, (Object)portName);
            if (data == null || data.length <= 0) break block18;
            this.kktSerialNumber = "";
            this.packageReader.write(data, data.length);
            if (!this.kktSerialNumber.contains(portData.getSerialNumber())) break block18;
            PortResult portResult = new PortResult(portData.getSerialNumber(), portName);
            this.LOG.debug("{} Port find for serial number {} port: {}", this.instanceId, portData.getSerialNumber(), portName);
            PortResult portResult2 = portResult;
            if (serialPort == null || !serialPort.isOpened()) return portResult2;
            try {
                serialPort.closePort();
                return portResult2;
            }
            catch (Exception e) {
                this.LOG.error("{} Error close port for {} {}", this.instanceId, portData.getSerialNumber(), portName, e);
            }
            return portResult2;
        }
        if (serialPort == null || !serialPort.isOpened()) return null;
        try {
            serialPort.closePort();
            return null;
        }
        catch (Exception e) {
            this.LOG.error("{} Error close port for {} {}", this.instanceId, portData.getSerialNumber(), portName, e);
        }
        return null;
        catch (Exception e) {
            try {
                this.LOG.error("{} Error find port for {} {}", this.instanceId, portData.getSerialNumber(), portName, e);
                if (serialPort == null || !serialPort.isOpened()) return null;
            }
            catch (Throwable throwable) {
                if (serialPort == null || !serialPort.isOpened()) throw throwable;
                try {
                    serialPort.closePort();
                    throw throwable;
                }
                catch (Exception e2) {
                    this.LOG.error("{} Error close port for {} {}", this.instanceId, portData.getSerialNumber(), portName, e2);
                }
                throw throwable;
            }
            try {
                serialPort.closePort();
                return null;
            }
            catch (Exception e3) {
                this.LOG.error("{} Error close port for {} {}", this.instanceId, portData.getSerialNumber(), portName, e3);
            }
            return null;
        }
    }

    private ComPacket makeGetSerialNumberComPacket() {
        return ProxyModel.makeCommand(2, 228, ComPacket.STATUS.END, "1");
    }
}

