/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.config.portFinder;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.comproxy.config.ProxyConfig;
import org.comproxy.config.portFinder.PortCheckerBySerialThread;
import org.comproxy.config.portFinder.PortData;
import org.comproxy.config.portFinder.PortFinderFromListThread;
import org.comproxy.config.portFinder.PortResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortFinderModel {
    public static final Logger LOG = LoggerFactory.getLogger(PortFinderModel.class);
    private static final PortFinderModel INSTANCE = new PortFinderModel();
    private BlockingQueue<PortData> portFindTask = new LinkedBlockingQueue<PortData>();
    private BlockingQueue<PortResult> portFindResult = new LinkedBlockingQueue<PortResult>();
    private static Lock lock = new ReentrantLock();
    private String instanceId = "0";

    private PortFinderModel() {
    }

    public static PortFinderModel getInstance() {
        return INSTANCE;
    }

    public boolean addTask(PortData portData) {
        LOG.debug(this.instanceId + " PortFinderModel addTask for {} size {}", (Object)portData.getSerialNumber(), (Object)this.portFindTask.size());
        return this.portFindTask.add(portData);
    }

    public PortData pollTask() {
        LOG.debug(this.instanceId + " PortFinderModel pollTask for {} size ", (Object)this.portFindTask.size());
        return (PortData)this.portFindTask.poll();
    }

    public boolean addResult(PortResult portResult) {
        LOG.debug(this.instanceId + " PortFinderModel addResult for {} size {}", (Object)portResult.getSerialNumber(), (Object)this.portFindTask.size());
        return this.portFindResult.add(portResult);
    }

    public PortResult pollResult() {
        LOG.debug(this.instanceId + " PortFinderModel pollResult for {} size ", (Object)this.portFindResult.size());
        return (PortResult)this.portFindResult.poll();
    }

    public String findPort(String serialNumber, ProxyConfig proxyConfig, String instanceId) {
        if (proxyConfig.isFastStart()) {
            return proxyConfig.getPhysicalPortPrinter1();
        }
        lock.lock();
        this.instanceId = instanceId;
        LOG.debug(instanceId + " PortFinder findPort busy by {} ", (Object)serialNumber);
        String resultPortName = null;
        PortFinderModel.getInstance().addTask(new PortData(serialNumber));
        PortFinderFromListThread portFinderThread = new PortFinderFromListThread(proxyConfig, instanceId);
        portFinderThread.start();
        while (portFinderThread.isAlive()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        PortResult portResult = PortFinderModel.getInstance().pollResult();
        if (portResult != null) {
            resultPortName = portResult.getPortName();
        }
        portFinderThread.interrupt();
        LOG.debug(instanceId + " PortFinder findPort released by {} ", (Object)serialNumber);
        lock.unlock();
        return resultPortName;
    }

    public String checkPort(String serialNumber, ProxyConfig proxyConfig, String portName, String instanceId) {
        lock.lock();
        this.instanceId = instanceId;
        LOG.debug(instanceId + " PortFinder checkPort busy by {} {} ", (Object)serialNumber, (Object)portName);
        String resultPortName = null;
        PortFinderModel.getInstance().addTask(new PortData(serialNumber));
        PortCheckerBySerialThread portFinderThread = new PortCheckerBySerialThread(proxyConfig, portName, this.instanceId);
        portFinderThread.start();
        while (portFinderThread.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        PortResult portResult = PortFinderModel.getInstance().pollResult();
        if (portResult != null) {
            resultPortName = portResult.getPortName();
        }
        portFinderThread.interrupt();
        LOG.debug(instanceId + " PortFinder checkPort released by {} ", (Object)serialNumber);
        lock.unlock();
        return resultPortName;
    }
}

