/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.config;

import jssc.SerialPort;
import jssc.SerialPortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialWriterThread
extends Thread {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private SerialPort serialPort;
    private String strData;
    private byte[] byteData = null;

    public void setStrData(String data) {
        this.strData = data;
    }

    public void setByteData(byte[] data) {
        this.byteData = data;
    }

    public SerialWriterThread(SerialPort serialPort) {
        this.serialPort = serialPort;
        this.byteData = new byte[0];
    }

    public SerialWriterThread(SerialPort serialPort, byte[] dataToSend) {
        this.serialPort = serialPort;
        this.byteData = dataToSend;
    }

    @Override
    public void run() {
        try {
            this.serialPort.writeBytes(this.byteData);
        }
        catch (SerialPortException e) {
            try {
                if (this.serialPort.isOpened()) {
                    this.serialPort.closePort();
                }
            }
            catch (SerialPortException e1) {
                this.LOG.error("Error close portFinder {}", (Object)this.serialPort.getPortName(), (Object)e);
            }
            finally {
                try {
                    this.serialPort.closePort();
                }
                catch (SerialPortException e1) {
                    this.LOG.error("Error close portFinderFinally {}", (Object)this.serialPort.getPortName(), (Object)e);
                }
            }
            Thread.currentThread().interrupt();
        }
    }
}

