/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.com.classic;

import org.comproxy.ProxyModel;
import org.comproxy.com.ByteArrayLog;
import org.comproxy.com.ComConnector;
import org.comproxy.com.serialio.PortReaderJssc;
import org.comproxy.com.serialio.SerialPortJssc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosVirtualComThread
implements Runnable {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private ProxyModel model;
    private byte[] tempbuffer = null;
    private PortReaderJssc tunnelPortReader;
    private ComConnector comConnector;

    public PosVirtualComThread(ProxyModel model) {
        this.model = model;
        this.comConnector = model.getPosVirtualConnector();
        this.init();
    }

    private void init() {
        this.tunnelPortReader = new PortReaderJssc(this.comConnector.getSerialPort(), () -> {}, this.LOG);
        try {
            if (!this.comConnector.getSerialPort().isOpened()) {
                this.comConnector.getSerialPort().openPort();
            }
            ((SerialPortJssc)this.comConnector.getSerialPort()).addEventListener(this.tunnelPortReader, 1);
        }
        catch (Exception e) {
            this.LOG.error("Error", e);
        }
    }

    @Override
    public void run() {
        this.model.setLogMarkMdc();
        while (!Thread.interrupted()) {
            try {
                byte[] packet = null;
                packet = this.model.getCommandToPos();
                if (packet != null) {
                    this.sendToConnector(packet);
                }
                this.readFromConnector(this.comConnector);
            }
            catch (Exception e) {
                this.LOG.error("Error", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean readFromConnector(ComConnector connector) throws Exception {
        boolean needPause = true;
        try {
            while (!Thread.interrupted() && this.model.getHardwareChecker().isFiscalPrinterConnected() && this.tunnelPortReader.isHaveData()) {
                this.tempbuffer = this.tunnelPortReader.getBuffer();
                if (this.tempbuffer == null || this.tempbuffer.length <= 0) continue;
                int read = this.tempbuffer.length;
                byte[] buffer = new byte[read];
                System.arraycopy(this.tempbuffer, 0, buffer, 0, this.tempbuffer.length);
                this.LOG.debug("--> {}", (Object)new ByteArrayLog(buffer));
                this.model.sendCommandToIPCashTcp(buffer);
                needPause = false;
            }
        }
        catch (Throwable t) {
            this.LOG.error("", t);
            Thread.sleep(1000L);
            connector.reconnect();
        }
        return needPause;
    }

    private void sendToConnector(byte[] packet) throws Exception {
        if (packet != null && this.model.getHardwareChecker().isFiscalPrinterConnected()) {
            this.comConnector.getSerialPort().writeBytes(packet);
            this.LOG.debug("<-- {}", (Object)new ByteArrayLog(packet));
        }
    }
}

