/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.com;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import jssc.SerialPortException;
import jssc.SerialPortList;
import org.comproxy.com.serialio.CommonSerialPort;
import org.comproxy.com.serialio.SerialPortJssc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComConnector {
    private static final Logger LOG = LoggerFactory.getLogger(ComConnector.class);
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private CommonSerialPort serialPort = null;
    private AtomicBoolean open = new AtomicBoolean(false);
    private String portName;
    private int baudRate;
    private String logMark;

    public ComConnector(String portName, int baudRate, String logMark) {
        this.portName = portName;
        this.baudRate = baudRate;
        this.logMark = logMark;
        try {
            this.initOpen();
        }
        catch (Exception ex) {
            LOG.error(this.logMark + " Open portFinder " + portName + " fail");
        }
    }

    public void reconnect() {
        LOG.info(this.logMark + " Reconnect {}", (Object)this.portName);
        this.open.set(false);
        while (!this.open.get()) {
            try {
                if (this.serialPort != null && this.serialPort.isOpened()) {
                    LOG.info(this.logMark + " Try close portFinder {}", (Object)this.portName);
                    this.serialPort.closePort();
                    this.serialPort = null;
                    System.gc();
                }
                LOG.info(this.logMark + " Try open portFinder {}", (Object)this.portName);
                this.open();
            }
            catch (SerialPortException se) {
                LOG.error(this.logMark + " SerialPortException after set mask {}", (Object)se.getExceptionType());
                if (!se.getExceptionType().equals("Can't set mask")) break;
                LOG.info(this.logMark + " Try open portFinder after exception {}", (Object)this.portName);
                try {
                    this.open();
                }
                catch (Exception e) {
                    LOG.error(this.logMark + " Error try open portFinder after set mask" + this.portName, e);
                }
                break;
            }
            catch (Exception ex) {
                LOG.error(this.logMark + " Error reconnect portFinder " + this.portName, ex);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public CommonSerialPort getSerialPort() {
        return this.serialPort;
    }

    public void hwReset() throws Exception {
        if (this.serialPort != null) {
            this.serialPort.purgePort(8);
            this.serialPort.purgePort(4);
            this.serialPort.purgePort(2);
            this.serialPort.purgePort(1);
        }
    }

    protected void open() throws Exception {
        try {
            this.dataBits = 8;
            this.stopBits = 1;
            this.parity = 0;
            this.serialPort = new SerialPortJssc(this.portName);
            this.serialPort.openPort();
            this.serialPort.setParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
            LOG.info(this.logMark + " Com port name {}, baud {} opened", (Object)this.portName, (Object)this.baudRate);
            this.open.set(true);
        }
        catch (Throwable t) {
            this.open.set(false);
            LOG.error(this.logMark + " Error open portFinder: " + this.portName, t);
            this.enumPorts();
            throw new Exception("ERROR_OPEN_PORT");
        }
    }

    protected void initOpen() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.open();
                return;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    return;
                }
                LOG.error(this.logMark + " Error open port in init process : " + this.portName, e);
            }
        }
    }

    private void enumPorts() {
        if (LOG.isDebugEnabled()) {
            try {
                Object[] ports = SerialPortList.getPortNames();
                LOG.debug("{} List of available serial ports: {}", (Object)this.logMark, (Object)Arrays.toString(ports));
            }
            catch (Exception e) {
                LOG.error(this.logMark + " Get list of com ports failed", e);
            }
        }
    }

    public void close() {
        block4: {
            try {
                if (!this.serialPort.isOpened()) break block4;
                try {
                    this.serialPort.removeEventListener();
                }
                catch (SerialPortException serialPortException) {
                    // empty catch block
                }
                this.serialPort.closePort();
            }
            catch (Exception e) {
                LOG.error(this.logMark + " ", e);
            }
        }
    }

    public void directOpenPort() throws Exception {
        this.serialPort.openPort();
    }

    public void write(byte[] data) throws Exception {
        this.serialPort.writeBytes(data);
    }

    public String getPortName() {
        return this.portName;
    }
}

