/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.com;

import java.nio.charset.Charset;
import ru.crystals.agent.agentDataTransfer.utils.ComUtils;

public class ByteArrayLog {
    private static final Charset cp866 = Charset.forName("cp866");
    private byte[] byteArray;
    private int read;
    private final boolean onlyHex;

    private ByteArrayLog(byte[] byteArray, int read, boolean onlyHex) {
        this.byteArray = byteArray;
        this.read = read;
        this.onlyHex = onlyHex;
    }

    public ByteArrayLog(byte[] byteArray) {
        this(byteArray, byteArray.length, false);
    }

    public static ByteArrayLog onlyHex(byte[] byteArray, int read) {
        return new ByteArrayLog(byteArray, read, true);
    }

    public static ByteArrayLog onlyHex(byte[] byteArray) {
        return new ByteArrayLog(byteArray, byteArray.length, true);
    }

    public String toString() {
        if (this.byteArray == null) {
            return "null";
        }
        if (this.byteArray.length == 0) {
            return "";
        }
        if (this.byteArray.length == 1) {
            return String.format("0x%02X", this.byteArray[0]);
        }
        try {
            if (this.onlyHex) {
                return ComUtils.bytesToHex(this.byteArray, this.read);
            }
            return new String(this.byteArray, 0, this.read, cp866) + " | " + ComUtils.bytesToHex(this.byteArray, this.read);
        }
        catch (Exception e) {
            try {
                return "Error logging of command " + e + " " + ComUtils.bytesToHex(this.byteArray, this.read);
            }
            catch (Exception e1) {
                return "Error logging of command " + e1 + " " + ComUtils.bytesToHex(this.byteArray, this.byteArray.length);
            }
        }
    }
}

