/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import org.comproxy.ComputableValue;
import org.comproxy.SettingValue;

public class WritableSetting {
    private final SettingValue kktValue;
    private final SettingValue kktRelatedValue;
    private final ComputableValue computableValue;
    private final SettingValue currentValue;
    private String valueToWrite;
    private long lastComputedTime;

    public WritableSetting(int index, int packetId, SettingValue kktRelatedValue, ComputableValue computableValue) {
        this.kktValue = new SettingValue(index, packetId);
        this.currentValue = new SettingValue(index, 0);
        this.kktRelatedValue = kktRelatedValue;
        this.computableValue = computableValue;
    }

    public SettingValue getKktValue() {
        return this.kktValue;
    }

    public SettingValue getKktRelatedValue() {
        return this.kktRelatedValue;
    }

    public SettingValue getCurrentValue() {
        return this.currentValue;
    }

    public String getValueToWrite() {
        return this.valueToWrite;
    }

    public void setValueToWrite(String valueToWrite) {
        this.valueToWrite = valueToWrite;
    }

    public void computeValue() {
        if (this.computableValue == null) {
            return;
        }
        String computed = this.computableValue.compute(this.kktRelatedValue != null ? this.kktRelatedValue.getValue() : null);
        this.currentValue.setValue(computed);
        this.currentValue.setValid(this.currentValue.getValue() != null);
        if (computed != null) {
            this.lastComputedTime = System.currentTimeMillis();
        }
    }

    public long getLastComputedTime() {
        return this.lastComputedTime;
    }

    public void invalidateAll() {
        this.kktValue.setValid(false);
        this.currentValue.setValid(false);
        if (this.kktRelatedValue != null) {
            this.kktRelatedValue.setValid(false);
        }
    }

    public String toString() {
        return String.format("%s, current %s", this.kktValue, this.currentValue);
    }
}

