/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SystemInfo {
    private String zap = ";";
    private String osName = "";
    private String osVersion = "";
    private boolean linux = true;
    private boolean is64BitOS = false;

    public SystemInfo() {
        String arch = System.getProperty("os.arch");
        boolean isArm = "arm".equals(arch);
        if (isArm) {
            this.osName = "Linux ARM";
        } else {
            if (!System.getProperty("os.name").toLowerCase().contains("linux")) {
                this.linux = false;
            }
            if (!this.linux) {
                String archWin = System.getenv("PROCESSOR_ARCHITECTURE");
                String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
                String realArch = archWin.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
                this.is64BitOS = realArch.contains("64");
            } else {
                this.is64BitOS = arch.contains("64");
            }
            this.osName = String.format("%s %s", this.linux ? "Linux" : "Windows", this.is64BitOS ? "64bit" : "32bit");
        }
        this.zap = this.linux ? ":" : ";";
        this.osVersion = this.getOsVersionFromOs();
    }

    public boolean isIs64BitOS() {
        return this.is64BitOS;
    }

    public boolean isLinux() {
        return this.linux;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getZap() {
        return this.zap;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    private String getOsVersionFromOs() {
        String result = "";
        if (this.linux) {
            try {
                Process p = Runtime.getRuntime().exec("uname -r");
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                return in.readLine();
            }
            catch (IOException e) {
                return result;
            }
        }
        return System.getProperty("os.version");
    }
}

