/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.comproxy.ProxyModel;
import org.comproxy.SettingValue;
import org.comproxy.WritableSetting;
import org.comproxy.reader.ComPacket;
import org.comproxy.tcp.BackgroundHostResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsManager {
    private static final Logger log = LoggerFactory.getLogger(SettingsManager.class);
    public static final int INTERNAL_STATUS_PACKET_ID = 224;
    public static final int INTERNAL_TCP_RESULT_PACKET_ID = 118;
    public static final int INTERNAL_GET_VERSION_PACKET_ID = 227;
    public static final int INTERNAL_GET_SERIAL_NUMBER_PACKET_ID = 228;
    private static final int KKT_IP = 73;
    private static final int OFD_HOST = 77;
    private static final int OFD_IP = 75;
    private static final int OISM_HOST = 203;
    private static final int OISM_IP = 201;
    private static final int OISM_TIMEOUT = 204;
    private static final int OKP_HOST = 93;
    private static final int OKP_IP = 91;
    private static final int OKP_PORT = 92;
    private static final int OKP_TIMEOUT = 94;
    private final BackgroundHostResolver hostResolver;
    private final long settingsResultLifetime;
    private final ProxyModel model;
    private AtomicBoolean shiftOpened = new AtomicBoolean(false);
    private Integer kktVersion;
    private Map<Integer, SettingValue> queuedToRead = Collections.synchronizedMap(new HashMap());
    private Map<Integer, WritableSetting> queuedToSet = Collections.synchronizedMap(new HashMap());
    private Map<Integer, ComPacket> userQueuedToReadAndSet = Collections.synchronizedMap(new HashMap());
    private final SettingValue ofdHost;
    private final SettingValue oismHost;
    private final SettingValue okpUrl;
    private final SettingValue oismTimeout;
    private final SettingValue okpTimeout;
    private final WritableSetting kktIP;
    private final WritableSetting ofdIP;
    private final WritableSetting oismIP;
    private final WritableSetting okpIP;
    private final WritableSetting okpPort;
    private BlockingQueue<SettingValue> toRead = new LinkedBlockingQueue<SettingValue>();
    private BlockingQueue<WritableSetting> toWrite = new LinkedBlockingQueue<WritableSetting>();
    private ComPacket openShiftPacket;
    private Pattern urlPattern = Pattern.compile("(?:[A-z]+?://)?(?<host>.+?):(?<port>\\d+)");

    SettingsManager(BackgroundHostResolver hostResolver, long settingsResultLifetime, ProxyModel model) {
        this.hostResolver = hostResolver;
        this.settingsResultLifetime = settingsResultLifetime;
        this.model = model;
        this.ofdHost = new SettingValue(77, 225);
        this.oismHost = new SettingValue(203, 226);
        this.okpUrl = new SettingValue(93, 229);
        this.oismTimeout = new SettingValue(204, 230);
        this.okpTimeout = new SettingValue(94, 231);
        this.kktIP = new WritableSetting(73, 232, null, relatedValue -> this.getLocalIp());
        this.ofdIP = new WritableSetting(75, 233, this.ofdHost, this::resolveHost);
        this.oismIP = new WritableSetting(201, 234, this.oismHost, this::resolveHost);
        this.okpIP = new WritableSetting(91, 235, this.okpUrl, rawUrl -> {
            if (rawUrl == null) {
                return null;
            }
            try {
                Matcher matcher = this.urlPattern.matcher(rawUrl);
                if (!matcher.matches()) {
                    return null;
                }
                return this.resolveHost(matcher.group(1));
            }
            catch (Exception e) {
                log.debug("Invalid url {}: {}", (Object)rawUrl, (Object)e.getMessage());
                return null;
            }
        });
        this.okpPort = new WritableSetting(92, 236, this.okpUrl, rawUrl -> {
            if (rawUrl == null) {
                return null;
            }
            try {
                Matcher matcher = this.urlPattern.matcher(rawUrl);
                if (!matcher.matches()) {
                    return null;
                }
                if (this.resolveHost(matcher.group(1)) == null) {
                    return null;
                }
                return matcher.group(2);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    private String getLocalIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                String displayName;
                NetworkInterface ni = networkInterfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual() || !ni.isUp() || ni.isPointToPoint() || (displayName = ni.getDisplayName()) != null && (displayName.startsWith("VirtualBox") || displayName.startsWith("VMware"))) continue;
                Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress instanceof Inet6Address) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String resolveHost(String rawHost) {
        String host = StringUtils.trimToNull(rawHost);
        if (host == null) {
            return null;
        }
        return this.hostResolver.resolve(host);
    }

    private Map<Integer, SettingValue> getQueuedToRead() {
        return this.queuedToRead;
    }

    private Map<Integer, WritableSetting> getQueuedToSet() {
        return this.queuedToSet;
    }

    private BlockingQueue<SettingValue> getToRead() {
        return this.toRead;
    }

    private BlockingQueue<WritableSetting> getToWrite() {
        return this.toWrite;
    }

    public SettingValue getOismTimeout() {
        return this.oismTimeout;
    }

    public SettingValue getOkpTimeout() {
        return this.okpTimeout;
    }

    public WritableSetting getOfdIP() {
        return this.ofdIP;
    }

    public WritableSetting getOismIP() {
        return this.oismIP;
    }

    public WritableSetting getOkpIP() {
        return this.okpIP;
    }

    public boolean isAllRequested() {
        return this.okpPort.getKktValue().isValid();
    }

    public void requestAll() {
        this.ofdHost.setValid(false);
        this.oismHost.setValid(false);
        this.oismTimeout.setValid(false);
        this.okpTimeout.setValid(false);
        this.okpUrl.setValid(false);
        this.ofdIP.getKktValue().setValid(false);
        this.oismIP.getKktValue().setValid(false);
        this.kktIP.getKktValue().setValid(false);
        this.okpIP.getKktValue().setValid(false);
        this.okpPort.getKktValue().setValid(false);
        this.ofdIP.getCurrentValue().setValid(false);
        this.oismIP.getCurrentValue().setValid(false);
        this.kktIP.getCurrentValue().setValid(false);
        this.okpIP.getCurrentValue().setValid(false);
        this.okpPort.getCurrentValue().setValid(false);
        this.toRead(this.ofdHost);
        this.toRead(this.oismHost);
        this.toRead(this.oismTimeout);
        this.toRead(this.okpTimeout);
        this.toRead(this.okpUrl);
        this.toRead(this.ofdIP.getKktValue());
        this.toRead(this.oismIP.getKktValue());
        this.toRead(this.kktIP.getKktValue());
        this.toRead(this.okpIP.getKktValue());
        this.toRead(this.okpPort.getKktValue());
        this.toWrite(this.ofdIP);
        this.toWrite(this.oismIP);
        this.toWrite(this.kktIP);
        this.toWrite(this.okpIP);
        this.toWrite(this.okpPort);
    }

    private void toWrite(WritableSetting writableSetting) {
        if (writableSetting.getKktRelatedValue() == null || writableSetting.getKktRelatedValue().isSupported()) {
            this.getToWrite().offer(writableSetting);
            this.model.signalPhysical();
        }
    }

    private void toRead(SettingValue readOnlyValue) {
        if (readOnlyValue.isSupported()) {
            this.getToRead().offer(readOnlyValue);
            this.model.signalPhysical();
        }
    }

    public void requestAll(ComPacket openShiftPacket) {
        if (this.openShiftPacket != openShiftPacket) {
            this.openShiftPacket = openShiftPacket;
            this.requestAll();
        }
    }

    public ComPacket getPacketToSend() {
        if (!this.getQueuedToRead().isEmpty() || !this.getQueuedToSet().isEmpty()) {
            return null;
        }
        ComPacket readPacket = this.putReadPacketToSend();
        if (readPacket != null) {
            return readPacket;
        }
        ComPacket writePacket = this.putWritePacketToSend();
        if (writePacket != null) {
            return writePacket;
        }
        return null;
    }

    private boolean isInternalStatusPacket(ComPacket packet) {
        return packet.getPacketId() == 224 && "00".equals(packet.getPacketCommand());
    }

    private boolean isInternalGetVersionPacket(ComPacket packet, String value) {
        return packet.getPacketId() == 227 && "02".equals(packet.getPacketCommand()) && packet.getPacketValueByIndex(0).equals(value);
    }

    private boolean isInternalGetSerialNumberPacket(ComPacket packet, String value) {
        return packet.getPacketId() == 228 && "02".equals(packet.getPacketCommand()) && packet.getPacketValueByIndex(0).equals(value);
    }

    public boolean isShiftOpened() {
        return this.shiftOpened.get();
    }

    public void setShiftOpened(boolean opened) {
        if (this.shiftOpened.compareAndSet(!opened, opened)) {
            log.debug("Shift state is changed to " + (opened ? "opened" : "closed"));
        }
    }

    public Integer getKktVersion() {
        return this.kktVersion;
    }

    public void addUserRequest(ComPacket packet) {
        if (packet.getPacketId() == null) {
            return;
        }
        if (this.isInternalPacket(packet) || this.isInternalStatusPacket(packet)) {
            this.userQueuedToReadAndSet.put(packet.getPacketId(), packet);
        }
    }

    private boolean isConfigPacket(ComPacket packet) {
        Integer id = packet.getPacketId();
        String command = packet.getPacketCommand();
        return id >= 224 && id <= 239 && ("11".equals(command) || "12".equals(command));
    }

    private boolean removeUserPacket(ComPacket packet) {
        ComPacket userQueuedPacket = this.userQueuedToReadAndSet.get(packet.getPacketId());
        if (userQueuedPacket != null && userQueuedPacket.getPacketCommand().equals(packet.getPacketCommand())) {
            this.userQueuedToReadAndSet.remove(packet.getPacketId());
            log.debug("Ignore answer to user queued packet #{} {}", (Object)packet.getPacketId(), (Object)packet.getPacketCommand());
            return true;
        }
        return false;
    }

    private ComPacket makeWritePacket(int packetId, int index, String value) {
        return ProxyModel.makeCommand(18, packetId, ComPacket.STATUS.END, String.valueOf(index), "0", value);
    }

    private ComPacket makeReadPacket(int packetId, int index) {
        return ProxyModel.makeCommand(17, packetId, ComPacket.STATUS.END, String.valueOf(index), "0");
    }

    private ComPacket putReadPacketToSend() {
        SettingValue toRead = (SettingValue)this.getToRead().poll();
        if (toRead == null) {
            return null;
        }
        log.debug("Requested to read {}", (Object)toRead);
        this.getQueuedToRead().put(toRead.getPacketId(), toRead);
        return this.makeReadPacket(toRead.getPacketId(), toRead.getIndex());
    }

    private ComPacket putWritePacketToSend() {
        String valueToWrite;
        WritableSetting toWrite = (WritableSetting)this.getToWrite().poll();
        if (toWrite == null) {
            return null;
        }
        if (!toWrite.getKktValue().isValid()) {
            this.toWrite(toWrite);
            return null;
        }
        SettingValue kktRelatedValue = toWrite.getKktRelatedValue();
        if (kktRelatedValue != null && !kktRelatedValue.isValid()) {
            this.toWrite(toWrite);
            return null;
        }
        if (!toWrite.getCurrentValue().isValid()) {
            toWrite.computeValue();
            if (!toWrite.getCurrentValue().isValid()) {
                return this.putWritePacketToSend();
            }
        }
        if ((valueToWrite = toWrite.getCurrentValue().getValue()) == null || valueToWrite.equals(toWrite.getKktValue().getValue())) {
            return this.putWritePacketToSend();
        }
        toWrite.setValueToWrite(valueToWrite);
        log.debug("Requested to write {}", (Object)toWrite);
        this.getQueuedToSet().put(toWrite.getKktValue().getPacketId(), toWrite);
        return this.makeWritePacket(toWrite.getKktValue().getPacketId(), toWrite.getKktValue().getIndex(), toWrite.getValueToWrite());
    }

    public boolean processResponse(ComPacket response) {
        Integer packetId = response.getPacketId();
        if (packetId == null) {
            return false;
        }
        String packetCommand = response.getPacketCommand();
        if ("00".equals(packetCommand)) {
            int packetValueByIndex = Integer.parseInt(response.getPacketValueByIndex(1));
            if ((packetValueByIndex & 4) == 4) {
                this.setShiftOpened(true);
            }
            if (packetId == 224) {
                return !this.removeUserPacket(response);
            }
            return false;
        }
        if (this.isInternalGetVersionPacket(response, "2")) {
            if (this.kktVersion == null) {
                this.kktVersion = Integer.parseInt(response.getPacketValueByIndex(1));
                log.debug("Set kktVersion: {} to model ", (Object)this.kktVersion);
            }
            return !this.removeUserPacket(response);
        }
        if (!this.isConfigPacket(response) && !this.isInternalGetSerialNumberPacket(response, "1")) {
            return false;
        }
        if (this.removeUserPacket(response)) {
            return false;
        }
        if (packetCommand.equals("11")) {
            SettingValue requested = this.getQueuedToRead().remove(packetId);
            if (requested == null) {
                return true;
            }
            requested.setValid(true);
            if (response.isSuccessResponse()) {
                requested.setValue(response.getPacketValue());
                log.debug("Read setting {}", (Object)requested);
            } else {
                requested.setValue(null);
                if ("03".equals(response.getErrorCodeValue())) {
                    requested.setSupported(false);
                    log.debug("Unsupported setting {}", (Object)requested);
                } else {
                    log.debug("Read setting error {}", (Object)requested);
                }
            }
            return true;
        }
        if (packetCommand.equals("12")) {
            WritableSetting requested = this.getQueuedToSet().remove(packetId);
            if (requested == null) {
                return true;
            }
            if (response.isSuccessResponse()) {
                requested.getKktValue().setValue(requested.getValueToWrite());
                requested.getKktValue().setValid(true);
                requested.setValueToWrite(null);
                log.debug("Written setting {}", (Object)requested);
            }
            return true;
        }
        return true;
    }

    private boolean isInternalPacket(ComPacket response) {
        return this.isConfigPacket(response) || this.isInternalGetVersionPacket(response, "022") || this.isInternalGetSerialNumberPacket(response, "021");
    }

    public void refreshIfExpired(SettingValue readOnlyValue) {
        if (System.currentTimeMillis() - readOnlyValue.getLastValidTime() > this.settingsResultLifetime) {
            this.refresh(readOnlyValue);
        }
    }

    public void refreshIfExpired(WritableSetting writableSetting) {
        if (System.currentTimeMillis() - writableSetting.getLastComputedTime() > this.settingsResultLifetime) {
            this.refresh(writableSetting);
        }
    }

    private void refresh(SettingValue readOnlyValue) {
        readOnlyValue.setValid(false);
        this.toRead(readOnlyValue);
    }

    public void refresh(WritableSetting writableSetting) {
        writableSetting.invalidateAll();
        this.requestAll(writableSetting);
    }

    private void requestAll(WritableSetting writableSetting) {
        if (writableSetting.getKktRelatedValue() != null) {
            this.toRead(writableSetting.getKktRelatedValue());
        }
        this.toRead(writableSetting.getKktValue());
        this.toWrite(writableSetting);
    }
}

