/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.comproxy.CommonResources;
import org.comproxy.ModeManager;
import org.comproxy.SettingsManager;
import org.comproxy.SingleComProxyApiImpl;
import org.comproxy.com.ComConnector;
import org.comproxy.config.ProxyConfig;
import org.comproxy.reader.ByteArray;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.ImagePackageReader;
import org.comproxy.tcp.TCPService;
import org.comproxy.utils.ComUtils;
import org.comproxy.utils.HardwareChecker;
import org.comproxy.utils.PiritCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import ru.crystals.utils.time.Timer;

public class ProxyModel {
    private static final Logger log = LoggerFactory.getLogger(ProxyModel.class);
    private ComConnector physicalConnector;
    private ComConnector virtualConnector;
    private ComConnector posVirtualConnector;
    private TCPService tcpService;
    private BlockingQueue<ComPacket> virtualQueue = new LinkedBlockingQueue<ComPacket>();
    public final LinkedBlockingDeque<ComPacket> physicQueue;
    private LinkedBlockingDeque<byte[]> posQueue = new LinkedBlockingDeque();
    private LinkedBlockingDeque<byte[]> posTcpQueue = new LinkedBlockingDeque();
    private BlockingQueue<ComPacket> tcpRequestQueue = new LinkedBlockingQueue<ComPacket>();
    private BlockingQueue<ComPacket> tcpResponseQueue = new LinkedBlockingQueue<ComPacket>();
    private BlockingQueue<ComPacket> toAgentQueue = new LinkedBlockingQueue<ComPacket>();
    private BlockingQueue<ComPacket> fromAgentQueue = new LinkedBlockingQueue<ComPacket>();
    private AtomicBoolean tcpMode = new AtomicBoolean(false);
    private AtomicBoolean autoAnswer = new AtomicBoolean(false);
    private AtomicBoolean isTcpSendInProcess = new AtomicBoolean(false);
    private AtomicBoolean sendImageMode = new AtomicBoolean(false);
    private AtomicInteger restImageSize = new AtomicInteger(0);
    private AtomicBoolean frReadyForImage = new AtomicBoolean(false);
    private AtomicBoolean checkMarkMode = new AtomicBoolean(false);
    private AtomicReference<Integer> checkMarkCommandPacketId = new AtomicReference<Object>(null);
    private AtomicBoolean fnKeyMode = new AtomicBoolean(false);
    private AtomicReference<String> fnKeyCommand = new AtomicReference<Object>(null);
    private AtomicReference<Integer> fnKeyPacketId = new AtomicReference<Object>(null);
    private ImagePackageReader imagePackageReader;
    private boolean startAgent;
    private volatile int deviceStatus;
    private volatile int cashDrawerStatus;
    private HardwareChecker hardwareChecker;
    private String logMark;
    private String printerSerialNumber;
    private int instanceNumber;
    private AtomicBoolean stopAgentTechProcess = new AtomicBoolean(true);
    private static final int PiritAgentVersionBarrier = 565;
    private final Timer lastCommandTimer = Timer.expired(Duration.ofSeconds(2L));
    private final Timer lastCommandResponseTimer = Timer.expired(Duration.ofSeconds(10L));
    private final Timer lastNonStatusCommandTimer = Timer.expired(Duration.ofSeconds(5L));
    private final Timer imgModeTimer = Timer.expired(Duration.ofSeconds(5L));
    private final Timer checkMarkTimer = Timer.expired(Duration.ofSeconds(5L));
    private final Timer fnKeyTimer = Timer.expired(Duration.ofSeconds(35L));
    private final ReentrantLock comThreadReadyLock = new ReentrantLock();
    private final Condition dataAvailable = this.comThreadReadyLock.newCondition();
    private final ReentrantLock virtualThreadReadyLock = new ReentrantLock();
    private final Condition virtualDataAvailable = this.virtualThreadReadyLock.newCondition();
    private final SettingsManager settings;
    private final ModeManager modeManager;
    private SingleComProxyApiImpl comProxyApi;
    private static ComPacket errorComPacket = null;
    private static ComPacket checkKKTVerisonPacket = null;

    public ProxyModel(ComConnector physicalConnector, ComConnector virtualConnector, String logMark, String printerSerialNumber, ProxyConfig proxyConfig) {
        log.debug("Create ProxyModel {}", (Object)logMark);
        int bufferSize = proxyConfig != null && proxyConfig.getBufferSize() > 0 ? proxyConfig.getBufferSize() : Integer.MAX_VALUE;
        long settingsResultLifetime = TimeUnit.SECONDS.toMillis(proxyConfig != null ? proxyConfig.getSettingsResultLifetime() : ProxyConfig.DEFAULT_SETTINGS_RESULT_LIFETIME);
        this.settings = new SettingsManager(CommonResources.getInstance().getHostResolver(), settingsResultLifetime, this);
        this.modeManager = new ModeManager(proxyConfig, this.settings);
        this.physicQueue = new LinkedBlockingDeque(bufferSize);
        this.physicalConnector = physicalConnector;
        this.virtualConnector = virtualConnector;
        this.logMark = logMark;
        this.printerSerialNumber = printerSerialNumber;
        this.imagePackageReader = ImagePackageReader.getInstance();
        this.hardwareChecker = new HardwareChecker(physicalConnector.getPortName(), this);
    }

    public ReentrantLock getComThreadReadyLock() {
        return this.comThreadReadyLock;
    }

    public Condition getDataAvailable() {
        return this.dataAvailable;
    }

    public ReentrantLock getVirtualThreadReadyLock() {
        return this.virtualThreadReadyLock;
    }

    public Condition getVirtualDataAvailable() {
        return this.virtualDataAvailable;
    }

    public void signalVirtual() {
        this.virtualThreadReadyLock.lock();
        try {
            this.virtualDataAvailable.signalAll();
        }
        finally {
            this.virtualThreadReadyLock.unlock();
        }
    }

    public void signalPhysical() {
        this.comThreadReadyLock.lock();
        try {
            this.dataAvailable.signalAll();
        }
        finally {
            this.comThreadReadyLock.unlock();
        }
    }

    public ModeManager getModeManager() {
        return this.modeManager;
    }

    public void onNewVirtualCommand(String packetCommand) {
        this.lastCommandTimer.restart();
        if (this.isNotStatusCommand(packetCommand)) {
            this.lastNonStatusCommandTimer.restart();
        }
    }

    public boolean isNotStatusCommand(String packetCommand) {
        return !"81".equals(packetCommand) && !"04".equals(packetCommand);
    }

    public boolean isFnSafeCommand(ComPacket packet) {
        if (packet == null) {
            return false;
        }
        String packetCommand = packet.getPacketCommand();
        if (packetCommand == null) {
            return false;
        }
        if (PiritCommands.FN_SAFE_COMMANDS.contains(packetCommand)) {
            return true;
        }
        return "02".equals(packetCommand) && "027".equals(packet.getPacketValue());
    }

    public boolean isNoTcpModeTimeoutOrStatusOnlyExpired() {
        return this.isNoTcpModeTimeoutExpired() || this.lastNonStatusCommandTimer.isExpired();
    }

    public boolean isNoTcpModeTimeoutExpired() {
        return this.lastCommandTimer.isExpired();
    }

    public boolean isStopAgentTechProcess() {
        return this.stopAgentTechProcess.get();
    }

    public void setStopAgentTechProcess(boolean stopAgentTechProcess) {
        this.stopAgentTechProcess.set(stopAgentTechProcess);
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setInstanceNumber(int instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public String getPrinterSerialNumber() {
        return this.printerSerialNumber;
    }

    public HardwareChecker getHardwareChecker() {
        return this.hardwareChecker;
    }

    public void setPosVirtualConnector(ComConnector posVirtualConnector) {
        this.posVirtualConnector = posVirtualConnector;
    }

    public Boolean isAgentSupportedByKkt() {
        if (this.settings.getKktVersion() == null) {
            return null;
        }
        return this.settings.getKktVersion() >= 565;
    }

    public boolean isAutoAnswerMode() {
        return this.autoAnswer.get();
    }

    public void setAutoAnswerMode(boolean autoAnswer) {
        if (this.autoAnswer.compareAndSet(!autoAnswer, autoAnswer)) {
            log.debug("autoAnswer set to {}", (Object)autoAnswer);
        }
    }

    public boolean isImageModeExpired() {
        return this.imgModeTimer.isExpired();
    }

    public boolean isCheckMarkModeExpired() {
        return this.checkMarkTimer.isExpired();
    }

    public boolean isFnKeyModeExpired() {
        return this.fnKeyTimer.isExpired();
    }

    public String getLogMark() {
        return this.logMark;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public void setDeviceStatus(int deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public int getCashDrawerStatus() {
        return this.cashDrawerStatus;
    }

    public void setCashDrawerStatus(int cashDrawerStatus) {
        this.cashDrawerStatus = cashDrawerStatus;
    }

    public Integer getKktVersion() {
        return this.settings.getKktVersion();
    }

    public ComConnector getPhysicalConnector() {
        return this.physicalConnector;
    }

    public ComConnector getVirtualConnector() {
        return this.virtualConnector;
    }

    public ComConnector getPosVirtualConnector() {
        return this.posVirtualConnector;
    }

    public void setCheckMarkMode(boolean mode, Integer packetId) {
        if (!this.checkMarkMode.compareAndSet(!mode, mode)) {
            return;
        }
        log.debug("Set checkMarkMode to {}", (Object)mode);
        this.checkMarkCommandPacketId.set(packetId);
        if (mode) {
            this.resetCheckMarkTimeout();
        }
    }

    public boolean isCheckMarkCommand(ComPacket packet) {
        return "79".equals(packet.getPacketCommand()) && "791".equals(packet.getPacketValue());
    }

    public boolean isCheckMarkResponse(ComPacket packet) {
        return "79".equals(packet.getPacketCommand()) && packet.getPacketId().equals(this.checkMarkCommandPacketId.get());
    }

    public boolean isCheckMarkMode() {
        return this.checkMarkMode.get();
    }

    public void setFnKeyMode(boolean mode, ComPacket packet) {
        if (!this.fnKeyMode.compareAndSet(!mode, mode)) {
            return;
        }
        log.debug("Set fn key mode to {}", (Object)mode);
        if (packet != null) {
            this.fnKeyCommand.set(packet.getPacketCommand());
            this.fnKeyPacketId.set(packet.getPacketId());
        }
        if (mode) {
            this.resetFnKeyTimeOut();
        }
    }

    public boolean isFnKeyModeCommand(ComPacket packet) {
        String cmd = packet.getPacketCommand();
        return "23".equals(cmd) || this.isShiftOpenerDocument(packet) || "79".equals(cmd) && "7953".equals(packet.getPacketValue());
    }

    public boolean isShiftOpenerDocument(ComPacket packet) {
        if (this.getSettings().isShiftOpened()) {
            return false;
        }
        String cmd = packet.getPacketCommand();
        if (cmd == null) {
            return false;
        }
        if (cmd.equals("58")) {
            return true;
        }
        if (cmd.equals("30")) {
            int docType = Integer.parseInt(packet.getPacketValueByIndex(0)) & 0xF;
            return docType == 2 || docType == 3 || docType == 6 || docType == 7;
        }
        return false;
    }

    public boolean isFnKeyResponse(ComPacket packet) {
        return packet.getPacketCommand().equals(this.fnKeyCommand.get()) && packet.getPacketId().equals(this.fnKeyPacketId.get());
    }

    public boolean isFnKeyMode() {
        return this.fnKeyMode.get();
    }

    public boolean isSendImageMode() {
        return this.sendImageMode.get();
    }

    public boolean isAvailableToAgent() {
        return !this.isSendImageMode() && !this.isExclusiveModeActive();
    }

    public void setSendImageMode(boolean sendImageMode) {
        if (!sendImageMode) {
            this.imagePackageReader.getImageBuffer().clear();
            this.setFrReadyForImage(false);
        }
        if (!this.sendImageMode.compareAndSet(!sendImageMode, sendImageMode)) {
            return;
        }
        log.debug("Set sendImageMode to {}", (Object)sendImageMode);
        if (sendImageMode) {
            this.resetImageModeTimeOut();
        }
    }

    public AtomicInteger getRestImageSize() {
        return this.restImageSize;
    }

    public boolean isFrReadyForImage() {
        return this.frReadyForImage.get();
    }

    public void setFrReadyForImage(boolean frReadyForImage) {
        if (this.frReadyForImage.compareAndSet(!frReadyForImage, frReadyForImage)) {
            log.debug("Set frReadyForImage to {}", (Object)frReadyForImage);
        }
    }

    public void resetImageModeTimeOut() {
        this.imgModeTimer.restart();
    }

    public void resetFnKeyTimeOut() {
        this.fnKeyTimer.restart();
    }

    public void resetCheckMarkTimeout() {
        this.checkMarkTimer.restart();
    }

    public BlockingQueue<ByteArray> getImageBuffer() {
        return this.imagePackageReader.getImageBuffer();
    }

    public ByteArray pollImageBuffer() {
        log.debug("PollImageBuffer size: {}", (Object)this.imagePackageReader.getImageBuffer().size());
        return (ByteArray)this.imagePackageReader.getImageBuffer().poll();
    }

    public boolean isStartAgent() {
        return this.startAgent;
    }

    public void setStartAgent(boolean startAgent) {
        this.startAgent = startAgent;
    }

    public void responseTCP(ComPacket packet) {
        this.tcpResponseQueue.add(packet);
        this.signalPhysical();
    }

    public void trySwitchToTCPMode() {
        if (!this.isNoTcpModeTimeoutOrStatusOnlyExpired()) {
            this.setTcpMode(false);
            log.info("TCP mode off because last command timer not expired");
            return;
        }
        if (!this.physicQueue.isEmpty()) {
            this.setTcpMode(false);
            log.info("TCP mode off because physicQueue isn`t empty: {}", (Object)this.physicQueue.peek());
            return;
        }
        this.setAutoAnswerMode(true);
        this.setTcpMode(true);
    }

    public void turnOffTcpReadMode() {
        log.debug("turnOffTcpReadMode");
        this.sendStopTcp();
        this.setTcpMode(false);
        this.setAutoAnswerMode(false);
        if (!this.tcpResponseQueue.isEmpty()) {
            log.debug("tcpResponseQueue cleared {}", (Object)this.tcpResponseQueue.size());
            this.tcpResponseQueue.clear();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            log.error("", ex);
        }
    }

    private void setTcpMode(boolean newValue) {
        if (this.tcpMode.compareAndSet(!newValue, newValue)) {
            log.debug("tcpMode set to {}", (Object)newValue);
        }
    }

    public void sendCommandToPhysical(ComPacket packet) {
        this.comThreadReadyLock.lock();
        try {
            this.physicQueue.put(packet);
            this.dataAvailable.signalAll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        finally {
            this.comThreadReadyLock.unlock();
        }
    }

    public void sendStopTcp() {
        log.debug("SendStopTcp");
        this.sendCommandToPhysical(ComPacket.DC3_PACKET);
    }

    public void sendFirstStopTcp(String reason) {
        log.debug("Ignore new TCP requests: {}", (Object)reason);
        this.sendFirstCommandToPhysical(ComPacket.DC3_PACKET);
    }

    public void sendFirstCommandToPhysical(ComPacket packet, String message) {
        log.debug("Send first to physical ({}): {}", (Object)message, (Object)packet);
        this.sendFirstCommandToPhysical(packet);
    }

    public void sendFirstCommandToPhysical(ComPacket packet) {
        this.comThreadReadyLock.lock();
        try {
            this.physicQueue.putFirst(packet);
            this.dataAvailable.signalAll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        finally {
            this.comThreadReadyLock.unlock();
        }
    }

    public void sendCommandToVirtual(ComPacket packet) {
        this.virtualQueue.add(packet);
        this.signalVirtual();
    }

    public void sendCommandToPos(byte[] packet) {
        this.posQueue.add(packet);
    }

    public void sendCommandToIPCashTcp(byte[] packet) {
        this.posTcpQueue.add(packet);
    }

    public void sendCommandToTCP(ComPacket packet) {
        this.tcpRequestQueue.add(packet);
    }

    public void addPacketToAgent(ComPacket packet) {
        this.toAgentQueue.add(packet);
    }

    public int getQueueToAgentSize() {
        return this.toAgentQueue.size();
    }

    public ComPacket getPacketToAgent() {
        return (ComPacket)this.toAgentQueue.poll();
    }

    public void addPacketFromAgent(ComPacket packet) {
        this.comThreadReadyLock.lock();
        try {
            this.fromAgentQueue.add(packet);
            this.dataAvailable.signalAll();
        }
        finally {
            this.comThreadReadyLock.unlock();
        }
    }

    public boolean hasFromAgent() {
        return !this.fromAgentQueue.isEmpty();
    }

    public ComPacket getPacketFromAgent() {
        return (ComPacket)this.fromAgentQueue.poll();
    }

    public ComPacket pollPacketToPhysic() {
        return this.physicQueue.poll();
    }

    public boolean hasPacketToPhysic() {
        return !this.physicQueue.isEmpty();
    }

    public ComPacket getPacketToVirtual() {
        return (ComPacket)this.virtualQueue.poll();
    }

    public boolean hasPacketToVirtual() {
        return !this.virtualQueue.isEmpty();
    }

    public byte[] getCommandToPos() {
        return this.posQueue.poll();
    }

    public byte[] getCommandToIPCashTcp() {
        return this.posTcpQueue.poll();
    }

    public ComPacket getTcpResponsePacket() {
        return (ComPacket)this.tcpResponseQueue.poll();
    }

    public ComPacket getPacketToTcp() throws InterruptedException {
        return this.tcpRequestQueue.poll(1L, TimeUnit.MINUTES);
    }

    public boolean isTcpReadMode() {
        return this.tcpMode.get();
    }

    public static ComPacket makeCommand(int command, int packetId, ComPacket.STATUS status, String ... params) {
        try {
            String commandString = String.format("%02X", command);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(2);
            ProxyModel.writePrefix(baos);
            baos.write(packetId & 0xFF);
            baos.write(commandString.getBytes());
            if (params != null && params.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (String param : params) {
                    if (sb.length() > 0) {
                        sb.append('\u001c');
                    }
                    sb.append(param);
                }
                baos.write(sb.toString().getBytes());
            }
            baos.write(3);
            baos.write(ComUtils.createCrc(baos.toByteArray()).getBytes());
            return new ComPacket(baos.toByteArray(), status, packetId, commandString);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected IO exception on ByteArrayOutputStream", ex);
        }
    }

    private static void writePrefix(OutputStream os) throws IOException {
        os.write("PIRI".getBytes());
    }

    public void sendCheckKKTVersion() {
        if (checkKKTVerisonPacket == null) {
            checkKKTVerisonPacket = this.makeGetVersionComPacket();
        }
        this.sendCommandToPhysical(checkKKTVerisonPacket);
        this.sendCommandToPhysical(ProxyModel.makeGetDevInfoComPacket());
    }

    private ComPacket makeGetVersionComPacket() {
        return ProxyModel.makeCommand(2, 227, ComPacket.STATUS.END, "2");
    }

    public static ComPacket makeGetDevInfoComPacket() {
        return ProxyModel.makeCommand(0, 224, ComPacket.STATUS.END, new String[0]);
    }

    private static ComPacket makeOFDErrorComPacket() {
        return ProxyModel.makeCommand(132, 118, ComPacket.STATUS.TCP, "0");
    }

    public void sendFailTcpCommandToPhysic() {
        if (this.isCheckMarkMode() || this.isFnKeyMode() || !this.isTcpReadMode()) {
            return;
        }
        this.sendCommandToPhysical(ProxyModel.getTcpErrorPacket());
    }

    private static ComPacket getTcpErrorPacket() {
        if (errorComPacket == null) {
            errorComPacket = ProxyModel.makeOFDErrorComPacket();
        }
        return errorComPacket;
    }

    public void tcpSendInProcess(boolean value) {
        this.isTcpSendInProcess.set(value);
    }

    public boolean isTcpSendInProcess() {
        return this.isTcpSendInProcess.get();
    }

    public void setLogMarkMdc() {
        MDC.put("MARK", this.logMark);
    }

    public void setLogMarkMdc(String suffix) {
        MDC.put("MARK", this.logMark + suffix);
    }

    public void waitForFRConnected() throws InterruptedException {
        if (this.getHardwareChecker().isFiscalPrinterConnected()) {
            return;
        }
        log.debug("Wait for device connected... ");
        while (!this.getHardwareChecker().isFiscalPrinterConnected()) {
            Thread.sleep(200L);
        }
        log.debug("Device connected");
    }

    public void setTcpService(TCPService tcpService) {
        this.tcpService = tcpService;
    }

    public TCPService getTcpService() {
        return this.tcpService;
    }

    public void deactivateExpiredModes() {
        if (this.isCheckMarkMode() && this.isCheckMarkModeExpired()) {
            log.debug("checkMarkMode expired");
            this.setCheckMarkMode(false, null);
            return;
        }
        if (this.isFnKeyMode() && this.isFnKeyModeExpired()) {
            log.debug("fn key mode expired");
            this.setFnKeyMode(false, null);
        }
    }

    public boolean isExclusiveModeActive() {
        return this.isCheckMarkMode() || this.isFnKeyMode();
    }

    public boolean processResponseOnExclusiveMode(ComPacket result) {
        if (this.isCheckMarkMode() && this.isCheckMarkResponse(result)) {
            this.setCheckMarkMode(false, null);
            return true;
        }
        if (this.isFnKeyMode() && this.isFnKeyResponse(result)) {
            this.setFnKeyMode(false, null);
            return true;
        }
        return false;
    }

    public SettingsManager getSettings() {
        return this.settings;
    }

    public void setComProxyApi(SingleComProxyApiImpl comProxyApi) {
        this.comProxyApi = comProxyApi;
    }

    public SingleComProxyApiImpl getComProxyApi() {
        return this.comProxyApi;
    }

    public void resetKktAnswerTimeout() {
        this.lastCommandResponseTimer.restart();
    }

    public boolean isKktAnswerExpired(long answerTimeoutNs, long lastCommandTimeoutNs) {
        long lastResponse = this.lastCommandResponseTimer.getElapsedNanos();
        long lastCommand = this.lastCommandTimer.getElapsedNanos();
        if (lastResponse == 0L || lastCommand == 0L) {
            return false;
        }
        long lastDifference = lastCommand - lastResponse;
        return lastDifference >= answerTimeoutNs && System.nanoTime() - lastCommand <= lastCommandTimeoutNs && System.nanoTime() - lastResponse >= lastCommandTimeoutNs;
    }
}

