/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.crystals.utils.time.Timer;

public class Mode {
    private static final Logger log = LoggerFactory.getLogger(Mode.class);
    private final AtomicBoolean enabled = new AtomicBoolean();
    private final AtomicInteger activationThresholdCounter = new AtomicInteger(0);
    private final String modeName;
    private final Timer modeTimer;
    private final int activationThreshold;

    public Mode(String modeName, long timeoutSec, int activationThreshold) {
        this.modeName = modeName;
        this.modeTimer = Timer.expired(Duration.ofSeconds(timeoutSec));
        this.activationThreshold = activationThreshold;
    }

    public boolean tryToEnable() {
        boolean result;
        if (this.isEnabled()) {
            return true;
        }
        int attempts = this.activationThresholdCounter.incrementAndGet();
        if (attempts >= this.activationThreshold && (result = this.changeState(true))) {
            log.debug("{} mode is activated after {} failed attempts", (Object)this.modeName, (Object)attempts);
        }
        return false;
    }

    public boolean disable() {
        boolean result = this.changeState(false);
        if (result) {
            log.debug("{} mode is deactivated", (Object)this.modeName);
        }
        return result;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean isNotExpired() {
        return this.isEnabled() && this.modeTimer.isNotExpired();
    }

    private boolean changeState(boolean newState) {
        boolean result = this.enabled.compareAndSet(!newState, newState);
        if (result) {
            if (newState) {
                this.modeTimer.restart();
            } else {
                this.activationThresholdCounter.set(0);
            }
        }
        return result;
    }

    public String getModeName() {
        return this.modeName;
    }

    public String toString() {
        return this.modeName + " is " + (this.enabled.get() ? "enabled" : "disabled");
    }
}

