/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentServiceController {
    private static final Logger LOG = LoggerFactory.getLogger(AgentServiceController.class);
    private String agentClassName;
    private boolean dreamkasMode;
    private File agentServiceFile;
    private final String homePath;
    private boolean useLocalAgent;
    private Class<?> cls;

    public AgentServiceController(String agentServiceFileName, String homePath, boolean localAgent) {
        this.homePath = homePath;
        if (localAgent) {
            try {
                this.cls = Class.forName("ru.crystals.agent.agentMain.AgentServiceStarter");
                this.useLocalAgent = true;
                return;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.agentServiceFile = new File(agentServiceFileName);
        if (!this.agentServiceFile.exists()) {
            this.dreamkasMode = true;
            return;
        }
        this.agentClassName = this.getAgentClassName(this.agentServiceFile);
        this.dreamkasMode = this.agentClassName == null || this.agentClassName.startsWith("ru.dreamkas");
    }

    private String getAgentClassName(File agentServiceFileName) {
        try {
            JarFile jarFile = new JarFile(agentServiceFileName);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(Attributes.Name.MAIN_CLASS);
        }
        catch (Exception e) {
            LOG.error("Error get agent class name", e);
            return null;
        }
    }

    public void start() {
        if (this.dreamkasMode) {
            return;
        }
        try {
            if (this.useLocalAgent) {
                LOG.debug("Try using local agent");
                Class[] paramTypes = new Class[]{String.class};
                Method startProcess = this.cls.getDeclaredMethod("startLocalProcess", paramTypes);
                startProcess.invoke(null, this.homePath);
                LOG.debug("AgentService started");
            } else {
                LOG.debug("Try start AgentService file path : {}", (Object)this.agentServiceFile);
                URL[] urls = new URL[]{this.agentServiceFile.toURI().toURL()};
                URLClassLoader loader = new URLClassLoader(urls);
                this.cls = loader.loadClass(this.agentClassName);
                Class[] paramTypes = new Class[]{String.class};
                Method startProcess = this.cls.getDeclaredMethod("startProcess", paramTypes);
                startProcess.invoke(null, this.homePath);
                LOG.debug("AgentService started");
            }
        }
        catch (Exception e) {
            LOG.error("Error start agent service", e);
        }
    }

    public boolean isDreamkasMode() {
        return this.dreamkasMode;
    }
}

