/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.taskUpdater;

import com.company.updater.updaterTasks.UpdaterTask;
import com.company.updater.updaterTasks.UpdaterTaskDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdaterTaskReader {
    private static final Logger LOG = LoggerFactory.getLogger(UpdaterTaskReader.class);
    private Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UpdaterTask.class), new UpdaterTaskDeserializer()).create();
    private String homePath;

    public UpdaterTaskReader(String homePath) {
        this.homePath = homePath;
    }

    public List<UpdaterTask> read() {
        return this.readUpdaterTasksFromFiles(this.getUpdaterTaskFiles());
    }

    private List<UpdaterTask> readUpdaterTasksFromFiles(File[] files) {
        ArrayList<UpdaterTask> updaterTasks = new ArrayList<UpdaterTask>();
        for (File taskFile : files) {
            updaterTasks.addAll(Arrays.asList(this.readData(taskFile)));
        }
        return updaterTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdaterTask[] readData(File taskFile) {
        LOG.info("Start read task data {}", (Object)taskFile.getAbsolutePath());
        UpdaterTask[] taskResult = null;
        BufferedReader br = null;
        if (taskFile.exists()) {
            String taskFilePath = taskFile.getAbsolutePath();
            try {
                String line;
                br = new BufferedReader(new FileReader(taskFilePath));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                LOG.info("Read task data data : {}", (Object)sb.toString());
                taskResult = this.gson.fromJson(sb.toString(), UpdaterTask[].class);
                LOG.info("End read task data");
                UpdaterTask[] updaterTaskArray = taskResult;
                return updaterTaskArray;
            }
            catch (IOException e) {
                LOG.error("Read task data error {}", e);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error("Close file error {}", ex);
                }
            }
        }
        LOG.info("Task don't have task file");
        return taskResult;
    }

    public File[] getUpdaterTaskFiles() {
        File[] result = new File[]{};
        File taskdir = new File(this.homePath + File.separator + "tasks");
        if (taskdir.exists()) {
            result = taskdir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("updater_tasks");
                }
            });
        }
        return result;
    }
}

