/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.logConfig;

import com.company.updater.logConfig.CustomLogAppender.CustomDailyRollingFileAppender;
import java.io.File;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LogConfig {
    private static final String LOG_FILE_NAME = "ComProxyUpdater.log";
    private static String logsPath;
    private static final String LOG_DIR = "logs";
    private static final String loggerName = "ComProxyUpdater";

    public static void configureLogger(String homePath) {
        logsPath = LogConfig.resolve(homePath, LOG_DIR);
        File logDir = new File(logsPath);
        logDir.mkdir();
        String LOGGER_PATTERN = "%d{dd.MM HH:mm:ss.SSS} %-5p [%-25c{1}] %m%n";
        ConsoleAppender console = new ConsoleAppender();
        console.setLayout(new PatternLayout(LOGGER_PATTERN));
        console.setThreshold(Level.TRACE);
        console.activateOptions();
        CustomDailyRollingFileAppender fa = new CustomDailyRollingFileAppender();
        fa.setName("FileLogger");
        fa.setFile(LogConfig.resolve(logsPath, LOG_FILE_NAME));
        fa.setLayout(new PatternLayout(LOGGER_PATTERN));
        fa.setDatePattern("'.'yyyy-MM-dd");
        fa.setMaxBackupIndex(5);
        fa.setCreateZipArchive(true);
        console.setThreshold(Level.TRACE);
        fa.setAppend(true);
        fa.setEncoding("UTF-8");
        fa.activateOptions();
        Logger.getLogger("com.company.updater").addAppender(console);
        Logger.getLogger("com.company.updater").addAppender(fa);
    }

    private static String resolve(String path, String pathToResolve) {
        if (path.endsWith(File.separator)) {
            return path + pathToResolve;
        }
        return path + File.separator + pathToResolve;
    }

    public static String getLogFileName() {
        return LOG_FILE_NAME;
    }
}

