/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.logConfig.CustomLogAppender;

import com.company.updater.logConfig.CustomLogAppender.ModifiedTimeSortableFile;
import com.company.updater.logConfig.LogConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class CustomDailyRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    protected int maxBackupIndex = 1;
    protected boolean createZipArchive = true;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public void setCreateZipArchive(boolean createZipArchive) {
        this.createZipArchive = createZipArchive;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public CustomDailyRollingFileAppender() {
    }

    public CustomDailyRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    @Override
    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
        } else {
            LogLog.error("Either File or DatePattern options are not setIsRegistered for appender [" + this.name + "].");
        }
    }

    private List<ModifiedTimeSortableFile> getAllFiles() {
        ArrayList<ModifiedTimeSortableFile> files = new ArrayList<ModifiedTimeSortableFile>();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String directoryName = dir.getPath();
                LogLog.debug("directory name: " + directoryName);
                File file = new File(CustomDailyRollingFileAppender.this.fileName);
                String parentDirectory = file.getParent();
                if (parentDirectory != null) {
                    String localFile = CustomDailyRollingFileAppender.this.fileName.substring(directoryName.length());
                    return name.startsWith(localFile);
                }
                return name.startsWith(CustomDailyRollingFileAppender.this.fileName);
            }
        };
        File file = new File(this.fileName);
        String parentDirectory = file.getParent();
        if (file.exists() && file.getParent() == null) {
            String absolutePath = file.getAbsolutePath();
            parentDirectory = absolutePath.substring(0, absolutePath.lastIndexOf(this.fileName));
        }
        String logFileMame = LogConfig.getLogFileName();
        String logPrefix = logFileMame.replaceAll("log", "");
        File dir = new File(parentDirectory);
        LinkedList<String> arList = new LinkedList<String>();
        arList.addAll(Arrays.asList(dir.list()));
        arList.remove(logFileMame);
        LinkedList<String> tmpList = new LinkedList<String>();
        for (String s : arList) {
            if (!(s.startsWith(logPrefix) | s.startsWith("archive." + logPrefix))) continue;
            tmpList.add(s);
        }
        arList.clear();
        arList.addAll(tmpList);
        String[] names = new String[arList.size()];
        names = arList.toArray(names);
        for (int i = 0; i < names.length; ++i) {
            files.add(new ModifiedTimeSortableFile(dir + System.getProperty("file.separator") + names[i]));
        }
        return files;
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug("Appender [" + this.name + "] to be rolled every minute.");
                break;
            }
            case 1: {
                LogLog.debug("Appender [" + this.name + "] to be rolled on top of every hour.");
                break;
            }
            case 2: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at midday and midnight.");
                break;
            }
            case 3: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at midnight.");
                break;
            }
            case 4: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at start of week.");
                break;
            }
            case 5: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at start of every month.");
                break;
            }
            default: {
                LogLog.warn("Unknown periodicity for appender [" + this.name + "].");
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.getDefault());
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipCompressing(File file) throws IOException {
        byte[] buffer = new byte[4096];
        String zipOut = file.getParent() + System.getProperty("file.separator") + "archive." + file.getName() + ".zip";
        ZipOutputStream outstream = new ZipOutputStream(new FileOutputStream(zipOut));
        File currentFile = new File(file.getAbsolutePath());
        if (currentFile.exists()) {
            FileInputStream fis = null;
            try {
                int bytesRead;
                fis = new FileInputStream(currentFile);
                ZipEntry entry = new ZipEntry(currentFile.getName());
                outstream.putNextEntry(entry);
                while ((bytesRead = fis.read(buffer)) != -1) {
                    outstream.write(buffer, 0, bytesRead);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        outstream.close();
    }

    void rollOver() throws IOException {
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
        } else {
            String datedFilename = this.fileName + this.sdf.format(this.now);
            List<ModifiedTimeSortableFile> files = this.getAllFiles();
            Collections.sort(files);
            if (!this.scheduledFilename.equals(datedFilename)) {
                File file;
                boolean result;
                this.closeFile();
                File target = new File(this.scheduledFilename);
                if (target.exists()) {
                    target.delete();
                }
                if (files.size() >= this.maxBackupIndex) {
                    int index = 0;
                    int diff = files.size() - (this.maxBackupIndex - 1);
                    for (ModifiedTimeSortableFile file2 : files) {
                        if (index >= diff) break;
                        file2.delete();
                        ++index;
                    }
                }
                if (result = (file = new File(this.fileName)).renameTo(target)) {
                    LogLog.debug(this.fileName + " -> " + this.scheduledFilename);
                } else {
                    LogLog.error("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "].");
                }
                try {
                    this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                }
                catch (IOException var6) {
                    this.errorHandler.error("setFile(" + this.fileName + ", true) call failed.");
                }
                File targetZip = new File(this.scheduledFilename);
                if (targetZip.exists() && this.createZipArchive) {
                    this.zipCompressing(targetZip);
                    targetZip.delete();
                }
                this.scheduledFilename = datedFilename;
            }
        }
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException var5) {
                if (var5 instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error("rollOver() failed.", var5);
            }
        }
        super.subAppend(event);
    }

    class RollingCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -3560331770601814177L;
        int type;

        RollingCalendar() {
            this.type = -1;
        }

        RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
            this.type = -1;
        }

        void setType(int type) {
            this.type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }
}

