/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.legacy.softwareUpdater;

import com.company.updater.UnzipUtil;
import com.company.updater.softwareUpdater.ChangeFileThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUpdater.class);
    private static String oldJarPath = "";
    private static String newJarPath = "";
    private static String copyOldJarPath = "";
    private static boolean comProxyIsStopped = false;
    private static final long timeOut = 30000L;
    private static final long COMPPROXY_STOP_TIME_OUT = 15000L;
    private static final String AGENT_LIBS_FOLDER_NAME = "\\agent\\libs";

    public static void main(String[] args) {
        ClientUpdater.update("data.zip", "7777");
    }

    public static String[] update(String archiveName, String agentServicePID) {
        return ClientUpdater.updateJars(UnzipUtil.subFilderUnZip(archiveName), agentServicePID);
    }

    private static String[] updateJars(String[] jarNames, String agentServicePID) {
        String[] resultData = new String[3];
        for (String jarName : jarNames) {
            resultData = ClientUpdater.updateJar(jarName, agentServicePID);
            if (Objects.equals(resultData[0], "SUCCESS")) continue;
            ClientUpdater.deleteClientUpdateDataAndDir();
            return resultData;
        }
        ClientUpdater.deleteClientUpdateDataAndDir();
        return resultData;
    }

    private static void deleteClientUpdateDataAndDir() {
        File dir = new File(new File("").getAbsolutePath() + UnzipUtil.JARS_FOR_UPDATE_FOLDER);
        if (dir.isDirectory()) {
            for (File c : dir.listFiles()) {
                ClientUpdater.delete(c);
            }
        }
        dir.delete();
    }

    private static void replaceFolders() throws IOException {
        File agentFolderForUpdate = new File(new File("").getAbsolutePath() + AGENT_LIBS_FOLDER_NAME);
        File agentFolderWithUpdate = new File(new File("").getAbsolutePath() + UnzipUtil.JARS_FOR_UPDATE_FOLDER + AGENT_LIBS_FOLDER_NAME);
        if (agentFolderWithUpdate.exists()) {
            ClientUpdater.deleteAgentFiles(agentFolderForUpdate);
            ClientUpdater.copyFolder(agentFolderWithUpdate, agentFolderForUpdate);
        }
    }

    private static void delete(File file) {
        File[] fileList = file.listFiles();
        if (fileList != null) {
            for (File childFile : file.listFiles()) {
                if (childFile.isDirectory()) {
                    ClientUpdater.delete(childFile);
                } else {
                    childFile.delete();
                }
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    private static void deleteAgentFiles(File file) {
        File[] fileList;
        for (File f : fileList = file.listFiles()) {
            File currentFile = new File(file.getAbsolutePath(), f.getName());
            currentFile.delete();
        }
    }

    private static void copyFolder(File src, File dest) throws IOException {
        String[] files = src.list();
        if (files != null) {
            for (String file : files) {
                int length;
                FileInputStream in = new FileInputStream(src + File.separator + file);
                FileOutputStream out = new FileOutputStream(dest + File.separator + file);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                LOG.info("Copy {}", (Object)dest.getAbsolutePath());
            }
        }
    }

    private static String[] updateJar(String newJarName, String agentServicePID) {
        String[] resultData = new String[3];
        try {
            LOG.info("Start update jar {}", (Object)newJarName);
            File jarFile = new File("");
            File newJarFile = new File(jarFile.getAbsolutePath() + UnzipUtil.JARS_FOR_UPDATE_FOLDER + "\\" + newJarName);
            oldJarPath = jarFile.getAbsolutePath() + "\\" + newJarName;
            newJarPath = newJarFile.getAbsolutePath();
            if (!newJarFile.exists()) {
                LOG.info("No new jar file");
                resultData[0] = "";
                resultData[1] = "";
                resultData[2] = "";
                return resultData;
            }
            LOG.info("Old Jar Path : " + oldJarPath);
            LOG.info("New Jar Path : " + newJarPath);
            File oldVerisonDir = new File(jarFile.getAbsolutePath() + "\\oldVersion");
            oldVerisonDir.mkdir();
            copyOldJarPath = oldVerisonDir.getAbsolutePath() + "\\old_" + newJarName;
            LOG.info("Copy old jar path : " + copyOldJarPath);
            File oldJarFile = new File(oldJarPath);
            File copyOldJarFile = new File(copyOldJarPath);
            try {
                ClientUpdater.copyFile(oldJarFile, copyOldJarFile);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
                resultData[0] = "ERROR";
                resultData[1] = "1";
                resultData[2] = "ERROR COPY OLD FILE";
                return resultData;
            }
            if (!comProxyIsStopped && (resultData = ClientUpdater.waitStopServices(agentServicePID))[0] != null) {
                return resultData;
            }
            resultData = ClientUpdater.changeJar(new File(newJarPath), new File(oldJarPath));
        }
        catch (Throwable tw) {
            LOG.error(tw.getMessage() + " " + tw.getLocalizedMessage());
        }
        return resultData;
    }

    private static String[] waitStopServices(String agentServicePID) throws InterruptedException {
        String[] resultData = ClientUpdater.stopComProxyAndAgent(agentServicePID);
        if (resultData[0] != null) {
            return resultData;
        }
        Thread.sleep(15000L);
        return resultData;
    }

    private static String[] changeJar(File newJarFile, File oldJarFile) {
        String[] resultData = new String[3];
        ChangeFileThread renameFileThread = new ChangeFileThread(newJarFile, oldJarFile);
        renameFileThread.start();
        long timePoint = System.currentTimeMillis();
        while (renameFileThread.isAlive()) {
            if (timePoint + 30000L >= System.currentTimeMillis()) continue;
            renameFileThread.interrupt();
            LOG.error("Time out error delete file");
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "ERROR CHANGE FILE : " + newJarFile.getName();
            return resultData;
        }
        LOG.info("updateJars successful");
        try {
            ClientUpdater.replaceFolders();
        }
        catch (IOException e) {
            LOG.error("Can not update agent folder");
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "ERROR CHANGE AGENT LIBS FILE : " + newJarFile.getName();
            return resultData;
        }
        resultData[0] = "SUCCESS";
        return resultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
            LOG.info("Copy " + oldJarPath + " to " + copyOldJarPath + " successful");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Error copy " + oldJarPath + " to " + copyOldJarPath + " " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static String[] stopComProxyAndAgent(String agentServicePID) {
        String[] resultData = new String[3];
        try {
            LOG.info("Stopping ComProxy and Agent");
            ClientUpdater.stopAgent(agentServicePID);
            Process process = Runtime.getRuntime().exec("net stop ComProxy");
            process.waitFor();
            comProxyIsStopped = true;
            LOG.info("Stop ComProxy successful");
        }
        catch (IOException e) {
            LOG.error("Error stop ComProxy " + e.getMessage());
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "ERROR STOP COMPROXY";
        }
        catch (InterruptedException e1) {
            LOG.error("Error interrupt stop ComProxy " + e1.getMessage());
            LOG.error("Error stop ComProxy " + e1.getMessage());
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "ERROR INTERRUPT STOP COMPROXY";
        }
        return resultData;
    }

    private static void stopAgent(String PID) throws IOException {
        String cmd = "taskkill /F /PID " + PID;
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            throw new IOException("Error Stop Agent");
        }
    }

    public static void startComProxyAndAgent() {
        try {
            LOG.info("Starting ComProxy and Agent");
            Process process = Runtime.getRuntime().exec("net start ComProxy");
            process.waitFor();
            ProcessBuilder pb = new ProcessBuilder("agentService.exe");
            Process p = pb.start();
            LOG.info("Start ComProxy and Agent successful");
        }
        catch (IOException e) {
            LOG.error("Error start ComProxy and Agent " + e.getMessage());
        }
        catch (InterruptedException e1) {
            LOG.error("Error interrupt start ComProxy and Agent " + e1.getMessage());
        }
    }
}

