/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.legacy;

import com.company.updater.legacy.KKTUpdater;
import com.company.updater.legacy.TaskResultWriter;
import com.company.updater.legacy.softwareUpdater.ClientUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String PID_KEY = "-PID";
    private static final String UPDATE_TYPE_KEY = "-Type";
    private static final String SOFTWARE_FILE_NAME_KEY = "-Client";
    private static final String FIRMWARE_FILE_NAME_KEY = "-Firmware";
    private static final String PORT_NAME_KEY = "-Port";

    public static void main(String[] args) throws Exception {
        try {
            String[] params = Main.argsResolver(args);
            if (params[0] != null) {
                TaskResultWriter taskResultWriter;
                String[] resultData;
                if (params[0].equals("sw") && params[1] != null && params[4] != null) {
                    LOG.info("Start update Agent");
                    resultData = ClientUpdater.update(params[1], params[4]);
                    taskResultWriter = new TaskResultWriter();
                    taskResultWriter.writeTaskResult("upd_agent_task", resultData[0], resultData[1], resultData[2]);
                    ClientUpdater.startComProxyAndAgent();
                    LOG.info("End update Agent");
                }
                if (params[0].equals("fw") && params[2] != null && params[3] != null && params[4] != null) {
                    LOG.info("Start update KKT");
                    resultData = KKTUpdater.update(params[2], params[3], params[4]);
                    taskResultWriter = new TaskResultWriter();
                    taskResultWriter.writeTaskResult("upd_kkt_task", resultData[0], resultData[1], resultData[2]);
                    ClientUpdater.startComProxyAndAgent();
                    LOG.info("End update KKT");
                }
                if (params[0].equals("fw_sw") && params[1] != null && params[2] != null && params[3] != null && params[4] != null) {
                    LOG.info("Start update KKT and Agent");
                    resultData = KKTUpdater.update(params[2], params[3], params[4]);
                    taskResultWriter = new TaskResultWriter();
                    taskResultWriter.writeTaskResult("upd_kkt_task", resultData[0], resultData[1], resultData[2]);
                    resultData = ClientUpdater.update(params[1], params[4]);
                    taskResultWriter = new TaskResultWriter();
                    taskResultWriter.writeTaskResult("upd_agent_task", resultData[0], resultData[1], resultData[2]);
                    ClientUpdater.startComProxyAndAgent();
                    LOG.info("End update KKT and Agent");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Error ", (Object)e.getLocalizedMessage());
        }
    }

    private static String[] argsResolver(String[] args) {
        String[] result = new String[5];
        for (String arg : args) {
            if (arg.contains(UPDATE_TYPE_KEY)) {
                result[0] = Main.getValue(arg);
                continue;
            }
            if (arg.contains(SOFTWARE_FILE_NAME_KEY)) {
                result[1] = Main.getValue(arg);
                continue;
            }
            if (arg.contains(FIRMWARE_FILE_NAME_KEY)) {
                result[2] = Main.getValue(arg);
                continue;
            }
            if (arg.contains(PORT_NAME_KEY)) {
                result[3] = Main.getValue(arg);
                continue;
            }
            if (!arg.contains(PID_KEY)) continue;
            result[4] = Main.getValue(arg);
        }
        return result;
    }

    private static String getValue(String value) {
        return value.substring(value.indexOf("=") + 1);
    }
}

