/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.legacy;

import com.company.updater.legacy.softwareUpdater.ClientUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KKTUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUpdater.class);
    private static final String KSL_NAME = "KSL.exe";
    public static String def_filename = "update_kkt";

    public static String[] update(String firmawareName, String portNum, String agentServicePID) throws Exception {
        String[] result = KKTUpdater.updateFirmawareKKT(firmawareName, portNum, agentServicePID);
        KKTUpdater.deleteFirmwarefile(firmawareName);
        return result;
    }

    private static String[] updateFirmawareKKT(String firmawareName, String portNum, String agentServicePID) throws Exception {
        String[] resultData = new String[3];
        String currentDir = new File("").getAbsoluteFile().getAbsolutePath();
        String ksl_path = currentDir + "\\" + KSL_NAME;
        try {
            resultData = ClientUpdater.stopComProxyAndAgent(agentServicePID);
            if (resultData[0] != null) {
                return resultData;
            }
            Thread.sleep(15000L);
            int exitStatus = KKTUpdater.loadFirmWare(ksl_path, firmawareName, portNum);
            if (exitStatus == 1) {
                Thread.sleep(5000L);
                LOG.info("Second attempt");
                exitStatus = KKTUpdater.loadFirmWare(ksl_path, firmawareName, portNum);
            }
            if (exitStatus == 1) {
                Thread.sleep(5000L);
                LOG.info("Last attempt");
                exitStatus = KKTUpdater.loadFirmWare(ksl_path, firmawareName, portNum);
            }
            LOG.info("Firmware update end! Exit code: {}", (Object)exitStatus);
            if (exitStatus == 0) {
                resultData[0] = "SUCCESS";
                resultData[1] = "";
                resultData[2] = "";
                return resultData;
            }
            resultData[0] = "ERROR";
            resultData[1] = "2";
            resultData[2] = " ERROR_ON_FW_LOADING";
            return resultData;
        }
        catch (Exception e) {
            LOG.error("Error on start KSL {} " + e);
            resultData[0] = "ERROR";
            resultData[1] = "2";
            resultData[2] = " ERROR_ON_FW_START_KSL";
            return resultData;
        }
    }

    private static String getPortNumFromName(String portName) {
        return portName.substring(3);
    }

    private static int loadFirmWare(String ksl_path, String firmawareName, String portNum) throws IOException, InterruptedException {
        LOG.info("KSL start... for {} {}", (Object)firmawareName, (Object)portNum);
        ProcessBuilder builder = new ProcessBuilder(ksl_path, firmawareName, "-b3", "-c" + KKTUpdater.getPortNumFromName(portNum));
        Process p = builder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = "";
        while ((line = reader.readLine()) != null) {
            LOG.info(line);
        }
        p.waitFor();
        return p.exitValue();
    }

    private static void deleteFirmwarefile(String firmawareName) {
        LOG.info("Try delete firmware file");
        File file = new File(new File("").getAbsolutePath() + "\\" + firmawareName);
        if (file.exists()) {
            LOG.info("Firmware file exist");
            if (file.delete()) {
                LOG.info("Firmware file deleted");
            } else {
                LOG.info("Can not delete firmware file");
            }
        }
    }
}

