/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.firmwareUpdater;

import com.company.updater.UpdaterUtils;
import com.company.updater.firmwareUpdater.BaudRate;
import com.company.updater.firmwareUpdater.BiosMode;
import com.company.updater.firmwareUpdater.DeviceState;
import com.company.updater.firmwareUpdater.FlashBiosException;
import com.company.updater.firmwareUpdater.PortWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashBios {
    private static final byte[] ENQ = new byte[]{5};
    private static final Logger log = LoggerFactory.getLogger(FlashBios.class);
    private static final byte[] BIOS_VERSION_PIRIT2F = new byte[]{0, 4};
    private static final byte[] BIOS_VERSION_FM = new byte[]{0, 5};
    private static final byte[] ACK = new byte[]{6};
    private static final int CHUNK_SIZE = 256;
    private static final byte START_PACKET = 2;
    private static final byte[] START_FLASHING = new byte[]{1};
    private static final byte[] FINISH_FLASHING = new byte[]{4};
    private static final byte[] SWITCH_TO_BL = new byte[]{0, 98, 79, 95, 111, 84};

    public byte[][] loadBiosFile(File biosFile) throws FlashBiosException {
        if (biosFile.length() == 0L) {
            throw new FlashBiosException("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0444\u0430\u0439\u043b\u043e\u043c \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438: \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0440\u0430\u0437\u043c\u0435\u0440");
        }
        byte[][] partsToWrite = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(biosFile);
            int fullPartsCount = (int)biosFile.length() / 256;
            int restPart = (int)biosFile.length() % 256;
            int totalParts = fullPartsCount + Math.min(restPart, 1);
            partsToWrite = new byte[totalParts][258];
            for (int i = 0; i < totalParts; ++i) {
                int j;
                byte[] currentChunk = partsToWrite[i];
                currentChunk[0] = 2;
                int read = fileInputStream.read(currentChunk, 1, 256);
                if (read < 256) {
                    for (j = 1 + read; j < 257; ++j) {
                        currentChunk[j] = -1;
                    }
                }
                for (j = 1; j < 257; ++j) {
                    currentChunk[257] = (byte)(currentChunk[257] + currentChunk[j]);
                }
            }
        }
        catch (IOException e) {
            throw new FlashBiosException("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0444\u0430\u0439\u043b\u043e\u043c \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438", e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        log.debug("FW file {} loaded as {} parts to flash (total FW size {} bytes)", biosFile.getPath(), partsToWrite.length, biosFile.length());
        return partsToWrite;
    }

    public PortWrapper connectTo(String portName) throws SerialPortException {
        return this.connectTo(portName, 5, 2000);
    }

    public PortWrapper connectTo(String portName, int attempts, int timeout) throws SerialPortException {
        SerialPortException spe = null;
        for (int i = 1; i <= attempts; ++i) {
            try {
                PortWrapper serialPort = this.open(portName);
                log.info("Connecting to {} ({}/{}): connected", portName, i, attempts);
                return serialPort;
            }
            catch (SerialPortException e) {
                spe = e;
                log.info("Connecting to {} ({}/{}): {}", e.getPortName(), i, attempts, e.getExceptionType());
                try {
                    Thread.sleep(timeout);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }
        }
        throw spe;
    }

    private PortWrapper open(String portName) throws SerialPortException {
        SerialPort serialPort = new SerialPort(portName);
        serialPort.openPort();
        return new PortWrapper(serialPort);
    }

    private byte[] readEnq(PortWrapper portName) throws SerialPortException {
        byte[] secondByte;
        SerialPort serialPort = portName.getPort();
        serialPort.writeBytes(ENQ);
        this.logWrite(ENQ);
        byte[] firstByte = null;
        try {
            firstByte = serialPort.readBytes(1, 2000);
            this.logRead(firstByte);
        }
        catch (SerialPortTimeoutException e) {
            return new byte[0];
        }
        if (firstByte == null) {
            return new byte[0];
        }
        try {
            secondByte = serialPort.readBytes(1, 100);
        }
        catch (SerialPortTimeoutException e) {
            return firstByte;
        }
        if (secondByte != null && secondByte.length == 1) {
            this.logRead(secondByte);
            return new byte[]{firstByte[0], secondByte[0]};
        }
        return firstByte;
    }

    private void readGarbage(SerialPort serialPort) throws SerialPortException {
        this.readAnswer("garbage", serialPort);
    }

    private void readAnswer(String message, SerialPort serialPort) throws SerialPortException {
        try {
            this.logRead(message, serialPort.readBytes(1, 1000));
            this.logRead(message, serialPort.readBytes());
        }
        catch (SerialPortTimeoutException e) {
            return;
        }
    }

    private DeviceState foundOutDevice(PortWrapper portName, BaudRate baudRate, EnumSet<BaudRate> baudRates) throws SerialPortException {
        DeviceState deviceState = this.foundOutDevice(portName, baudRate);
        if (deviceState != null) {
            return deviceState;
        }
        return this.foundOutDevice(portName, baudRates.toArray(new BaudRate[0]));
    }

    public DeviceState foundOutDeviceAll(PortWrapper portName) throws SerialPortException {
        return this.foundOutDevice(portName, BaudRate.B115200, BaudRate.B57600, BaudRate.B19200);
    }

    public DeviceState foundOutDeviceAll(String portName) throws SerialPortException {
        return this.foundOutDevice(portName, BaudRate.B115200, BaudRate.B57600, BaudRate.B19200);
    }

    private DeviceState foundOutDevice(String portName, BaudRate ... baudRates) throws SerialPortException {
        try (PortWrapper port = this.connectTo(portName);){
            DeviceState deviceState = this.foundOutDevice(port, baudRates);
            return deviceState;
        }
    }

    private DeviceState foundOutDevice(PortWrapper port, BaudRate ... baudRates) throws SerialPortException {
        for (BaudRate rate : baudRates) {
            log.debug("Setting baud rate to {}", (Object)rate);
            port.setBaudRate(rate);
            this.readGarbage(port.getPort());
            BiosMode mode = this.foundOutDevice1(port);
            if (mode == null) continue;
            DeviceState deviceState = new DeviceState(mode, rate);
            log.info("Device found on {} in {} mode", (Object)deviceState.getBaudRate().getValue(), (Object)deviceState.getMode());
            return deviceState;
        }
        return null;
    }

    private BiosMode foundOutDevice1(PortWrapper portName) throws SerialPortException {
        byte[] ack = this.readEnq(portName);
        if (this.isAck(ack)) {
            return BiosMode.NORMAL;
        }
        if (this.isBootloaderVersion(ack)) {
            return BiosMode.BOOTLOADER;
        }
        return null;
    }

    private boolean isAck(byte[] response) {
        return response.length == 1 && response[0] == 6;
    }

    private boolean isBootloaderVersion(byte[] response) {
        return Arrays.equals(response, BIOS_VERSION_PIRIT2F) || Arrays.equals(response, BIOS_VERSION_FM);
    }

    public boolean findAndPrepareToBoot(String portName, BaudRate bootLoaderBaudRate) throws SerialPortException {
        DeviceState deviceState;
        try (PortWrapper portWrapper = this.connectTo(portName);){
            deviceState = this.foundOutDeviceAll(portWrapper);
            if (deviceState == null) {
                log.error("Device not found on {}", (Object)portName);
                boolean bl = false;
                return bl;
            }
            if (deviceState.getMode() == BiosMode.BOOTLOADER) {
                boolean bl = this.checkAndSetBlBaudRate(portWrapper, bootLoaderBaudRate, deviceState.getBaudRate());
                return bl;
            }
            this.switchToBootLoader(portWrapper);
        }
        portWrapper = this.connectTo(portName);
        var5_4 = null;
        try {
            DeviceState switchedDevice = this.foundOutDevice(portWrapper, BaudRate.B115200, BaudRate.B19200, BaudRate.B57600);
            if (switchedDevice == null) {
                log.error("Device not found after switching to bootloader");
                boolean bl = false;
                return bl;
            }
            if (switchedDevice.getMode() != BiosMode.BOOTLOADER) {
                log.error("Device not switched to bootloader");
                boolean bl = false;
                return bl;
            }
            this.readGarbage(portWrapper.getPort());
            boolean bl = this.checkAndSetBlBaudRate(portWrapper, bootLoaderBaudRate, deviceState.getBaudRate());
            return bl;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (portWrapper != null) {
                if (var5_4 != null) {
                    try {
                        portWrapper.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    portWrapper.close();
                }
            }
        }
    }

    private void switchToBootLoader(PortWrapper portName) throws SerialPortException {
        this.readGarbage(portName.getPort());
        log.info("Switching to BOOTLOADER mode");
        this.write(portName, SWITCH_TO_BL);
        this.readAnswer("switchToBl", portName.getPort());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean checkAndSetBlBaudRate(PortWrapper port, BaudRate bootLoaderBaudRate, BaudRate baudRate) throws SerialPortException {
        if (baudRate == bootLoaderBaudRate) {
            log.info("Device already in expected baud rate {}", (Object)bootLoaderBaudRate);
            return true;
        }
        log.info("Changing bootloader baud rate to {}", (Object)bootLoaderBaudRate);
        this.setBaudRateToBl(port, bootLoaderBaudRate);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        DeviceState preparedDevice = this.foundOutDevice(port, bootLoaderBaudRate);
        if (preparedDevice != null && preparedDevice.getMode() == BiosMode.BOOTLOADER) {
            return true;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        preparedDevice = this.foundOutDevice(port, bootLoaderBaudRate, EnumSet.complementOf(EnumSet.of(bootLoaderBaudRate)));
        if (preparedDevice == null) {
            log.error("Device not found after changing baud rate");
            return false;
        }
        if (preparedDevice.getMode() != BiosMode.BOOTLOADER) {
            log.error("Device not switched to bootloader");
            return false;
        }
        return true;
    }

    private void setBaudRateToBl(PortWrapper portName, BaudRate newBaudRate) throws SerialPortException {
        this.readGarbage(portName.getPort());
        this.write(portName, new byte[]{7, newBaudRate.getBlIndex()});
        this.readAnswer("setBaudRate", portName.getPort());
    }

    private void write(PortWrapper port, byte[] bytes) throws SerialPortException {
        SerialPort serialPort = port.getPort();
        serialPort.writeBytes(bytes);
        this.logWrite(bytes);
    }

    private void logRead(byte[] read) {
        this.logRead("", read);
    }

    private void logRead(String message, byte[] read) {
        if (read == null) {
            return;
        }
        log.info("--> {} {}", (Object)UpdaterUtils.bytesToHex(read, read.length), (Object)message);
    }

    private void logWrite(byte[] write) {
        log.info("<-- {}", (Object)UpdaterUtils.bytesToHex(write, write.length));
    }

    public void flashBios(String portName, BaudRate baudRate, byte[][] writeDataCommands) throws SerialPortException, SerialPortTimeoutException {
        try (PortWrapper port = this.connectTo(portName);){
            port.setBaudRate(baudRate);
            this.readGarbage(port.getPort());
            log.debug("Starting flashing");
            this.write(port, START_FLASHING);
            byte[] read = port.getPort().readBytes(1, 10000);
            this.logRead("", read);
            if (!this.isAck(read)) {
                log.error("Error on start flashing");
                return;
            }
            int totalParts = writeDataCommands.length;
            int counter = 1;
            int lastPercent = 0;
            for (byte[] writeCommand : writeDataCommands) {
                port.getPort().writeBytes(writeCommand);
                byte[] ackOnPart = port.getPort().readBytes(1, 1000);
                if (!this.isAck(ackOnPart)) {
                    log.error("Error on flashing block {}/{}", (Object)counter, (Object)totalParts);
                    return;
                }
                if (counter == 1) {
                    log.debug("Written 0% ({}/{})", (Object)counter, (Object)totalParts);
                } else if (counter == totalParts) {
                    log.debug("Written 100% ({}/{})", (Object)counter, (Object)totalParts);
                } else {
                    int currentPercent = (int)Math.round((double)counter / (double)totalParts * 100.0);
                    if (currentPercent % 5 == 0 && lastPercent != currentPercent && currentPercent != 100) {
                        lastPercent = currentPercent;
                        log.debug("Written {}% ({}/{})", currentPercent, counter, totalParts);
                    }
                }
                ++counter;
            }
            log.debug("Finishing flashing");
            this.write(port, FINISH_FLASHING);
            byte[] finished = port.getPort().readBytes(1, 2000);
            this.logRead("", finished);
            if (!this.isAck(finished)) {
                log.error("Error on finish flashing");
                return;
            }
        }
    }
}

