/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.PiritProlocol;

import com.company.updater.PiritProlocol.ByteArrayLog;
import com.company.updater.PiritProlocol.TcpHeader;
import com.company.updater.UpdaterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComPacket {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private byte[] packetBody;
    private STATUS status;
    private Byte packetId;
    private String packetCommand;
    private TcpHeader tcpHeader;
    private Long pauseAfterSend;

    public ComPacket(byte[] packetBody) {
        this(packetBody, STATUS.END, null, null, null);
    }

    public ComPacket(byte[] packetBody, STATUS status, Byte packetId, String packetCommand, TcpHeader tcpHeader) {
        this.packetBody = packetBody;
        this.status = status;
        this.packetId = packetId;
        this.packetCommand = packetCommand;
        this.tcpHeader = tcpHeader;
    }

    public boolean testCommand(byte shortCommand) {
        return this.packetBody.length == 1 && this.packetBody[0] == shortCommand;
    }

    public void setPacketBody(byte[] packetBody) {
        this.packetBody = packetBody;
    }

    public byte[] getPacketBody() {
        return this.packetBody;
    }

    public String getPacketValue() {
        int skipFirst;
        String result = "";
        int stxIndex = -1;
        int etxIndex = -1;
        for (int i = 0; i < this.packetBody.length; ++i) {
            byte b = this.packetBody[i];
            if (b == 2) {
                stxIndex = i;
                continue;
            }
            if (b != 3 && b != 28) continue;
            etxIndex = i;
            break;
        }
        if (etxIndex - (skipFirst = 5) > stxIndex && stxIndex >= 0) {
            byte[] value = new byte[etxIndex - stxIndex - skipFirst - 1];
            System.arraycopy(this.packetBody, stxIndex + skipFirst + 1, value, 0, value.length);
            try {
                result = new String(value, "cp866");
            }
            catch (UnsupportedEncodingException ex) {
                this.LOG.error("", ex);
            }
        }
        return result;
    }

    public String getErrorCodeValue() {
        int skipFirst;
        String result = "";
        int stxIndex = -1;
        int etxIndex = -1;
        for (int i = 0; i < this.packetBody.length; ++i) {
            byte b = this.packetBody[i];
            if (b == 2) {
                stxIndex = i;
                continue;
            }
            if (b != 3 && b != 28) continue;
            etxIndex = i;
            break;
        }
        if (etxIndex - (skipFirst = 3) > stxIndex && stxIndex >= 0) {
            byte[] value = new byte[2];
            System.arraycopy(this.packetBody, stxIndex + skipFirst + 1, value, 0, value.length);
            try {
                result = new String(value, "cp866");
            }
            catch (UnsupportedEncodingException ex) {
                this.LOG.error("", ex);
            }
        }
        return result;
    }

    public String getSerialNumberValue() {
        byte b;
        int i;
        String result = "";
        int stxIndex = -1;
        int etxIndex = -1;
        int startFsIndex = -1;
        int endFsIndex = -1;
        for (i = 0; i < this.packetBody.length; ++i) {
            b = this.packetBody[i];
            if (b == 2) {
                stxIndex = i;
                continue;
            }
            if (b != 28) continue;
            startFsIndex = i;
            break;
        }
        for (i = startFsIndex + 1; i > etxIndex; ++i) {
            b = this.packetBody[i];
            if (b != 28) continue;
            endFsIndex = i;
            break;
        }
        int skipFirst = 5;
        byte[] value = new byte[endFsIndex - startFsIndex];
        System.arraycopy(this.packetBody, startFsIndex, value, 0, value.length);
        try {
            result = new String(value, "cp866");
        }
        catch (UnsupportedEncodingException ex) {
            this.LOG.error("", ex);
        }
        return result;
    }

    public String getPacketValueByIndex(int number) {
        byte b;
        int i;
        if (number == 0) {
            return this.getPacketValue();
        }
        String result = "";
        int stxIndex = -1;
        int etxIndex = -1;
        int fsIndexPrevios = 0;
        int fsIndexNext = 6;
        int indexNumber = 0;
        for (i = 0; i < this.packetBody.length; ++i) {
            b = this.packetBody[i];
            if (b == 2) {
                stxIndex = i;
                continue;
            }
            if (b != 3) continue;
            etxIndex = i;
            break;
        }
        for (i = stxIndex; i < etxIndex; ++i) {
            b = this.packetBody[i];
            if (b == 28) {
                fsIndexPrevios = fsIndexNext;
                fsIndexNext = i;
                ++indexNumber;
            }
            if (indexNumber - 1 == number) {
                byte[] value = new byte[fsIndexNext - fsIndexPrevios - 1];
                System.arraycopy(this.packetBody, stxIndex + fsIndexPrevios + 1, value, 0, value.length);
                try {
                    result = new String(value, "cp866");
                }
                catch (UnsupportedEncodingException e) {
                    this.LOG.error("Error get value {} from packet: {}", (Object)number, (Object)this);
                }
                continue;
            }
            if (b != 3) continue;
            etxIndex = i;
            break;
        }
        return result;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public Byte getPacketId() {
        return this.packetId;
    }

    public String getPacketCommand() {
        return this.packetCommand;
    }

    public void setTcpHeader(TcpHeader tcpHeader) {
        this.tcpHeader = tcpHeader;
    }

    public TcpHeader getTcpHeader() {
        return this.tcpHeader;
    }

    public boolean checkTcpCrc() {
        boolean result = true;
        if (this.packetBody != null && this.packetBody.length > 11) {
            byte expectedCrc = this.packetBody[10];
            this.packetBody[11] = 0;
            this.packetBody[10] = 0;
            byte actualCrc = UpdaterUtils.byteCrc(this.packetBody);
            result = expectedCrc == actualCrc;
        }
        return result;
    }

    public Long getPauseAfterSend() {
        return this.pauseAfterSend;
    }

    public void setPauseAfterSend(Long pauseAfterSend) {
        this.pauseAfterSend = pauseAfterSend;
    }

    public String toString() {
        int id = 0;
        if (this.packetId != null) {
            id = this.packetId & 0xFF;
        }
        return "ComPacket{Id=" + id + ", command=" + this.packetCommand + ", status=" + (Object)((Object)this.status) + ", tcpHeader=" + this.tcpHeader + " - " + new ByteArrayLog(this.packetBody) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComPacket)) {
            return false;
        }
        ComPacket packet = (ComPacket)o;
        if (!Arrays.equals(this.packetBody, packet.packetBody)) {
            return false;
        }
        if (this.status != packet.status) {
            return false;
        }
        if (this.packetId != null ? !this.packetId.equals(packet.packetId) : packet.packetId != null) {
            return false;
        }
        if (this.packetCommand != null ? !this.packetCommand.equals(packet.packetCommand) : packet.packetCommand != null) {
            return false;
        }
        if (this.tcpHeader != null ? !this.tcpHeader.equals(packet.tcpHeader) : packet.tcpHeader != null) {
            return false;
        }
        return this.pauseAfterSend != null ? this.pauseAfterSend.equals(packet.pauseAfterSend) : packet.pauseAfterSend == null;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.packetBody);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.packetId != null ? this.packetId.hashCode() : 0);
        result = 31 * result + (this.packetCommand != null ? this.packetCommand.hashCode() : 0);
        result = 31 * result + (this.tcpHeader != null ? this.tcpHeader.hashCode() : 0);
        result = 31 * result + (this.pauseAfterSend != null ? this.pauseAfterSend.hashCode() : 0);
        return result;
    }

    public static enum STATUS {
        PACKET,
        END,
        TCP,
        ENDTCP,
        ERROR;

    }
}

